/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.model.HealthCheck;

public class HealthCheckUnmarshaller
implements Unmarshaller<HealthCheck, StaxUnmarshallerContext> {
    private static HealthCheckUnmarshaller INSTANCE;

    public HealthCheck unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        HealthCheck.Builder healthCheck = HealthCheck.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Target", targetDepth)) {
                    healthCheck.target(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Interval", targetDepth)) {
                    healthCheck.interval(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Timeout", targetDepth)) {
                    healthCheck.timeout(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("UnhealthyThreshold", targetDepth)) {
                    healthCheck.unhealthyThreshold(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("HealthyThreshold", targetDepth)) continue;
                healthCheck.healthyThreshold(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (HealthCheck)healthCheck.build();
    }

    public static HealthCheckUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new HealthCheckUnmarshaller();
        }
        return INSTANCE;
    }
}

