/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.elasticloadbalancing.model.ConfigureHealthCheckRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.HealthCheck;
import software.amazon.awssdk.util.StringUtils;

public class ConfigureHealthCheckRequestMarshaller
implements Marshaller<Request<ConfigureHealthCheckRequest>, ConfigureHealthCheckRequest> {
    public Request<ConfigureHealthCheckRequest> marshall(ConfigureHealthCheckRequest configureHealthCheckRequest) {
        HealthCheck healthCheck;
        if (configureHealthCheckRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)configureHealthCheckRequest, "ElasticLoadBalancingClient");
        request.addParameter("Action", "ConfigureHealthCheck");
        request.addParameter("Version", "2012-06-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (configureHealthCheckRequest.loadBalancerName() != null) {
            request.addParameter("LoadBalancerName", StringUtils.fromString((String)configureHealthCheckRequest.loadBalancerName()));
        }
        if ((healthCheck = configureHealthCheckRequest.healthCheck()) != null) {
            if (healthCheck.target() != null) {
                request.addParameter("HealthCheck.Target", StringUtils.fromString((String)healthCheck.target()));
            }
            if (healthCheck.interval() != null) {
                request.addParameter("HealthCheck.Interval", StringUtils.fromInteger((Integer)healthCheck.interval()));
            }
            if (healthCheck.timeout() != null) {
                request.addParameter("HealthCheck.Timeout", StringUtils.fromInteger((Integer)healthCheck.timeout()));
            }
            if (healthCheck.unhealthyThreshold() != null) {
                request.addParameter("HealthCheck.UnhealthyThreshold", StringUtils.fromInteger((Integer)healthCheck.unhealthyThreshold()));
            }
            if (healthCheck.healthyThreshold() != null) {
                request.addParameter("HealthCheck.HealthyThreshold", StringUtils.fromInteger((Integer)healthCheck.healthyThreshold()));
            }
        }
        return request;
    }
}

