/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.PolicyNamesCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SetLoadBalancerPoliciesForBackendServerRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, SetLoadBalancerPoliciesForBackendServerRequest> {
    private final String loadBalancerName;
    private final Integer instancePort;
    private final List<String> policyNames;

    private SetLoadBalancerPoliciesForBackendServerRequest(BuilderImpl builder) {
        this.loadBalancerName = builder.loadBalancerName;
        this.instancePort = builder.instancePort;
        this.policyNames = builder.policyNames;
    }

    public String loadBalancerName() {
        return this.loadBalancerName;
    }

    public Integer instancePort() {
        return this.instancePort;
    }

    public List<String> policyNames() {
        return this.policyNames;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.loadBalancerName() == null ? 0 : this.loadBalancerName().hashCode());
        hashCode = 31 * hashCode + (this.instancePort() == null ? 0 : this.instancePort().hashCode());
        hashCode = 31 * hashCode + (this.policyNames() == null ? 0 : this.policyNames().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetLoadBalancerPoliciesForBackendServerRequest)) {
            return false;
        }
        SetLoadBalancerPoliciesForBackendServerRequest other = (SetLoadBalancerPoliciesForBackendServerRequest)((Object)obj);
        if (other.loadBalancerName() == null ^ this.loadBalancerName() == null) {
            return false;
        }
        if (other.loadBalancerName() != null && !other.loadBalancerName().equals(this.loadBalancerName())) {
            return false;
        }
        if (other.instancePort() == null ^ this.instancePort() == null) {
            return false;
        }
        if (other.instancePort() != null && !other.instancePort().equals(this.instancePort())) {
            return false;
        }
        if (other.policyNames() == null ^ this.policyNames() == null) {
            return false;
        }
        return other.policyNames() == null || other.policyNames().equals(this.policyNames());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.loadBalancerName() != null) {
            sb.append("LoadBalancerName: ").append(this.loadBalancerName()).append(",");
        }
        if (this.instancePort() != null) {
            sb.append("InstancePort: ").append(this.instancePort()).append(",");
        }
        if (this.policyNames() != null) {
            sb.append("PolicyNames: ").append(this.policyNames()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String loadBalancerName;
        private Integer instancePort;
        private List<String> policyNames;

        private BuilderImpl() {
        }

        private BuilderImpl(SetLoadBalancerPoliciesForBackendServerRequest model) {
            this.setLoadBalancerName(model.loadBalancerName);
            this.setInstancePort(model.instancePort);
            this.setPolicyNames(model.policyNames);
        }

        public final String getLoadBalancerName() {
            return this.loadBalancerName;
        }

        @Override
        public final Builder loadBalancerName(String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
            return this;
        }

        public final void setLoadBalancerName(String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
        }

        public final Integer getInstancePort() {
            return this.instancePort;
        }

        @Override
        public final Builder instancePort(Integer instancePort) {
            this.instancePort = instancePort;
            return this;
        }

        public final void setInstancePort(Integer instancePort) {
            this.instancePort = instancePort;
        }

        public final Collection<String> getPolicyNames() {
            return this.policyNames;
        }

        @Override
        public final Builder policyNames(Collection<String> policyNames) {
            this.policyNames = PolicyNamesCopier.copy(policyNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyNames(String ... policyNames) {
            this.policyNames(Arrays.asList(policyNames));
            return this;
        }

        public final void setPolicyNames(Collection<String> policyNames) {
            this.policyNames = PolicyNamesCopier.copy(policyNames);
        }

        @SafeVarargs
        public final void setPolicyNames(String ... policyNames) {
            this.policyNames(Arrays.asList(policyNames));
        }

        public SetLoadBalancerPoliciesForBackendServerRequest build() {
            return new SetLoadBalancerPoliciesForBackendServerRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SetLoadBalancerPoliciesForBackendServerRequest> {
        public Builder loadBalancerName(String var1);

        public Builder instancePort(Integer var1);

        public Builder policyNames(Collection<String> var1);

        public Builder policyNames(String ... var1);
    }
}

