/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.Instance;
import software.amazon.awssdk.services.elasticloadbalancing.model.InstancesCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class RegisterInstancesWithLoadBalancerRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, RegisterInstancesWithLoadBalancerRequest> {
    private final String loadBalancerName;
    private final List<Instance> instances;

    private RegisterInstancesWithLoadBalancerRequest(BuilderImpl builder) {
        this.loadBalancerName = builder.loadBalancerName;
        this.instances = builder.instances;
    }

    public String loadBalancerName() {
        return this.loadBalancerName;
    }

    public List<Instance> instances() {
        return this.instances;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.loadBalancerName() == null ? 0 : this.loadBalancerName().hashCode());
        hashCode = 31 * hashCode + (this.instances() == null ? 0 : this.instances().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterInstancesWithLoadBalancerRequest)) {
            return false;
        }
        RegisterInstancesWithLoadBalancerRequest other = (RegisterInstancesWithLoadBalancerRequest)((Object)obj);
        if (other.loadBalancerName() == null ^ this.loadBalancerName() == null) {
            return false;
        }
        if (other.loadBalancerName() != null && !other.loadBalancerName().equals(this.loadBalancerName())) {
            return false;
        }
        if (other.instances() == null ^ this.instances() == null) {
            return false;
        }
        return other.instances() == null || other.instances().equals(this.instances());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.loadBalancerName() != null) {
            sb.append("LoadBalancerName: ").append(this.loadBalancerName()).append(",");
        }
        if (this.instances() != null) {
            sb.append("Instances: ").append(this.instances()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String loadBalancerName;
        private List<Instance> instances;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterInstancesWithLoadBalancerRequest model) {
            this.setLoadBalancerName(model.loadBalancerName);
            this.setInstances(model.instances);
        }

        public final String getLoadBalancerName() {
            return this.loadBalancerName;
        }

        @Override
        public final Builder loadBalancerName(String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
            return this;
        }

        public final void setLoadBalancerName(String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
        }

        public final Collection<Instance> getInstances() {
            return this.instances;
        }

        @Override
        public final Builder instances(Collection<Instance> instances) {
            this.instances = InstancesCopier.copy(instances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instances(Instance ... instances) {
            this.instances(Arrays.asList(instances));
            return this;
        }

        public final void setInstances(Collection<Instance> instances) {
            this.instances = InstancesCopier.copy(instances);
        }

        @SafeVarargs
        public final void setInstances(Instance ... instances) {
            this.instances(Arrays.asList(instances));
        }

        public RegisterInstancesWithLoadBalancerRequest build() {
            return new RegisterInstancesWithLoadBalancerRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, RegisterInstancesWithLoadBalancerRequest> {
        public Builder loadBalancerName(String var1);

        public Builder instances(Collection<Instance> var1);

        public Builder instances(Instance ... var1);
    }
}

