/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.elasticloadbalancing.model.LoadBalancerDescription;
import software.amazon.awssdk.services.elasticloadbalancing.model.LoadBalancerDescriptionsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeLoadBalancersResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeLoadBalancersResponse> {
    private final List<LoadBalancerDescription> loadBalancerDescriptions;
    private final String nextMarker;

    private DescribeLoadBalancersResponse(BuilderImpl builder) {
        this.loadBalancerDescriptions = builder.loadBalancerDescriptions;
        this.nextMarker = builder.nextMarker;
    }

    public List<LoadBalancerDescription> loadBalancerDescriptions() {
        return this.loadBalancerDescriptions;
    }

    public String nextMarker() {
        return this.nextMarker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.loadBalancerDescriptions() == null ? 0 : this.loadBalancerDescriptions().hashCode());
        hashCode = 31 * hashCode + (this.nextMarker() == null ? 0 : this.nextMarker().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLoadBalancersResponse)) {
            return false;
        }
        DescribeLoadBalancersResponse other = (DescribeLoadBalancersResponse)((Object)obj);
        if (other.loadBalancerDescriptions() == null ^ this.loadBalancerDescriptions() == null) {
            return false;
        }
        if (other.loadBalancerDescriptions() != null && !other.loadBalancerDescriptions().equals(this.loadBalancerDescriptions())) {
            return false;
        }
        if (other.nextMarker() == null ^ this.nextMarker() == null) {
            return false;
        }
        return other.nextMarker() == null || other.nextMarker().equals(this.nextMarker());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.loadBalancerDescriptions() != null) {
            sb.append("LoadBalancerDescriptions: ").append(this.loadBalancerDescriptions()).append(",");
        }
        if (this.nextMarker() != null) {
            sb.append("NextMarker: ").append(this.nextMarker()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<LoadBalancerDescription> loadBalancerDescriptions;
        private String nextMarker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLoadBalancersResponse model) {
            this.setLoadBalancerDescriptions(model.loadBalancerDescriptions);
            this.setNextMarker(model.nextMarker);
        }

        public final Collection<LoadBalancerDescription> getLoadBalancerDescriptions() {
            return this.loadBalancerDescriptions;
        }

        @Override
        public final Builder loadBalancerDescriptions(Collection<LoadBalancerDescription> loadBalancerDescriptions) {
            this.loadBalancerDescriptions = LoadBalancerDescriptionsCopier.copy(loadBalancerDescriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loadBalancerDescriptions(LoadBalancerDescription ... loadBalancerDescriptions) {
            this.loadBalancerDescriptions(Arrays.asList(loadBalancerDescriptions));
            return this;
        }

        public final void setLoadBalancerDescriptions(Collection<LoadBalancerDescription> loadBalancerDescriptions) {
            this.loadBalancerDescriptions = LoadBalancerDescriptionsCopier.copy(loadBalancerDescriptions);
        }

        @SafeVarargs
        public final void setLoadBalancerDescriptions(LoadBalancerDescription ... loadBalancerDescriptions) {
            this.loadBalancerDescriptions(Arrays.asList(loadBalancerDescriptions));
        }

        public final String getNextMarker() {
            return this.nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        public DescribeLoadBalancersResponse build() {
            return new DescribeLoadBalancersResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeLoadBalancersResponse> {
        public Builder loadBalancerDescriptions(Collection<LoadBalancerDescription> var1);

        public Builder loadBalancerDescriptions(LoadBalancerDescription ... var1);

        public Builder nextMarker(String var1);
    }
}

