/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.PolicyTypeNamesCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeLoadBalancerPolicyTypesRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeLoadBalancerPolicyTypesRequest> {
    private final List<String> policyTypeNames;

    private DescribeLoadBalancerPolicyTypesRequest(BuilderImpl builder) {
        this.policyTypeNames = builder.policyTypeNames;
    }

    public List<String> policyTypeNames() {
        return this.policyTypeNames;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.policyTypeNames() == null ? 0 : this.policyTypeNames().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLoadBalancerPolicyTypesRequest)) {
            return false;
        }
        DescribeLoadBalancerPolicyTypesRequest other = (DescribeLoadBalancerPolicyTypesRequest)((Object)obj);
        if (other.policyTypeNames() == null ^ this.policyTypeNames() == null) {
            return false;
        }
        return other.policyTypeNames() == null || other.policyTypeNames().equals(this.policyTypeNames());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.policyTypeNames() != null) {
            sb.append("PolicyTypeNames: ").append(this.policyTypeNames()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<String> policyTypeNames;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLoadBalancerPolicyTypesRequest model) {
            this.setPolicyTypeNames(model.policyTypeNames);
        }

        public final Collection<String> getPolicyTypeNames() {
            return this.policyTypeNames;
        }

        @Override
        public final Builder policyTypeNames(Collection<String> policyTypeNames) {
            this.policyTypeNames = PolicyTypeNamesCopier.copy(policyTypeNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyTypeNames(String ... policyTypeNames) {
            this.policyTypeNames(Arrays.asList(policyTypeNames));
            return this;
        }

        public final void setPolicyTypeNames(Collection<String> policyTypeNames) {
            this.policyTypeNames = PolicyTypeNamesCopier.copy(policyTypeNames);
        }

        @SafeVarargs
        public final void setPolicyTypeNames(String ... policyTypeNames) {
            this.policyTypeNames(Arrays.asList(policyTypeNames));
        }

        public DescribeLoadBalancerPolicyTypesRequest build() {
            return new DescribeLoadBalancerPolicyTypesRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeLoadBalancerPolicyTypesRequest> {
        public Builder policyTypeNames(Collection<String> var1);

        public Builder policyTypeNames(String ... var1);
    }
}

