/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.services.elasticloadbalancing.model.PolicyNamesCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class BackendServerDescription
implements ToCopyableBuilder<Builder, BackendServerDescription> {
    private final Integer instancePort;
    private final List<String> policyNames;

    private BackendServerDescription(BuilderImpl builder) {
        this.instancePort = builder.instancePort;
        this.policyNames = builder.policyNames;
    }

    public Integer instancePort() {
        return this.instancePort;
    }

    public List<String> policyNames() {
        return this.policyNames;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.instancePort() == null ? 0 : this.instancePort().hashCode());
        hashCode = 31 * hashCode + (this.policyNames() == null ? 0 : this.policyNames().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BackendServerDescription)) {
            return false;
        }
        BackendServerDescription other = (BackendServerDescription)obj;
        if (other.instancePort() == null ^ this.instancePort() == null) {
            return false;
        }
        if (other.instancePort() != null && !other.instancePort().equals(this.instancePort())) {
            return false;
        }
        if (other.policyNames() == null ^ this.policyNames() == null) {
            return false;
        }
        return other.policyNames() == null || other.policyNames().equals(this.policyNames());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.instancePort() != null) {
            sb.append("InstancePort: ").append(this.instancePort()).append(",");
        }
        if (this.policyNames() != null) {
            sb.append("PolicyNames: ").append(this.policyNames()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private Integer instancePort;
        private List<String> policyNames;

        private BuilderImpl() {
        }

        private BuilderImpl(BackendServerDescription model) {
            this.setInstancePort(model.instancePort);
            this.setPolicyNames(model.policyNames);
        }

        public final Integer getInstancePort() {
            return this.instancePort;
        }

        @Override
        public final Builder instancePort(Integer instancePort) {
            this.instancePort = instancePort;
            return this;
        }

        public final void setInstancePort(Integer instancePort) {
            this.instancePort = instancePort;
        }

        public final Collection<String> getPolicyNames() {
            return this.policyNames;
        }

        @Override
        public final Builder policyNames(Collection<String> policyNames) {
            this.policyNames = PolicyNamesCopier.copy(policyNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyNames(String ... policyNames) {
            this.policyNames(Arrays.asList(policyNames));
            return this;
        }

        public final void setPolicyNames(Collection<String> policyNames) {
            this.policyNames = PolicyNamesCopier.copy(policyNames);
        }

        @SafeVarargs
        public final void setPolicyNames(String ... policyNames) {
            this.policyNames(Arrays.asList(policyNames));
        }

        public BackendServerDescription build() {
            return new BackendServerDescription(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, BackendServerDescription> {
        public Builder instancePort(Integer var1);

        public Builder policyNames(Collection<String> var1);

        public Builder policyNames(String ... var1);
    }
}

