/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.elasticloadbalancing.model.CreateLoadBalancerPolicyRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.PolicyAttribute;

public class CreateLoadBalancerPolicyRequestMarshaller
implements Marshaller<Request<CreateLoadBalancerPolicyRequest>, CreateLoadBalancerPolicyRequest> {
    public Request<CreateLoadBalancerPolicyRequest> marshall(CreateLoadBalancerPolicyRequest createLoadBalancerPolicyRequest) {
        if (createLoadBalancerPolicyRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)createLoadBalancerPolicyRequest, "ElasticLoadBalancingClient");
        request.addParameter("Action", "CreateLoadBalancerPolicy");
        request.addParameter("Version", "2012-06-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (createLoadBalancerPolicyRequest.loadBalancerName() != null) {
            request.addParameter("LoadBalancerName", StringConversion.fromString((String)createLoadBalancerPolicyRequest.loadBalancerName()));
        }
        if (createLoadBalancerPolicyRequest.policyName() != null) {
            request.addParameter("PolicyName", StringConversion.fromString((String)createLoadBalancerPolicyRequest.policyName()));
        }
        if (createLoadBalancerPolicyRequest.policyTypeName() != null) {
            request.addParameter("PolicyTypeName", StringConversion.fromString((String)createLoadBalancerPolicyRequest.policyTypeName()));
        }
        if (createLoadBalancerPolicyRequest.policyAttributes().isEmpty() && !(createLoadBalancerPolicyRequest.policyAttributes() instanceof SdkAutoConstructList)) {
            request.addParameter("PolicyAttributes", "");
        } else if (!createLoadBalancerPolicyRequest.policyAttributes().isEmpty() && !(createLoadBalancerPolicyRequest.policyAttributes() instanceof SdkAutoConstructList)) {
            List<PolicyAttribute> policyAttributesList = createLoadBalancerPolicyRequest.policyAttributes();
            int policyAttributesListIndex = 1;
            for (PolicyAttribute policyAttributesListValue : policyAttributesList) {
                if (policyAttributesListValue.attributeName() != null) {
                    request.addParameter("PolicyAttributes.member." + policyAttributesListIndex + ".AttributeName", StringConversion.fromString((String)policyAttributesListValue.attributeName()));
                }
                if (policyAttributesListValue.attributeValue() != null) {
                    request.addParameter("PolicyAttributes.member." + policyAttributesListIndex + ".AttributeValue", StringConversion.fromString((String)policyAttributesListValue.attributeValue()));
                }
                ++policyAttributesListIndex;
            }
        }
        return request;
    }
}

