/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.elasticloadbalancing.model.ConfigureHealthCheckRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.HealthCheck;

public class ConfigureHealthCheckRequestMarshaller
implements Marshaller<Request<ConfigureHealthCheckRequest>, ConfigureHealthCheckRequest> {
    public Request<ConfigureHealthCheckRequest> marshall(ConfigureHealthCheckRequest configureHealthCheckRequest) {
        HealthCheck healthCheck;
        if (configureHealthCheckRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)configureHealthCheckRequest, "ElasticLoadBalancingClient");
        request.addParameter("Action", "ConfigureHealthCheck");
        request.addParameter("Version", "2012-06-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (configureHealthCheckRequest.loadBalancerName() != null) {
            request.addParameter("LoadBalancerName", StringConversion.fromString((String)configureHealthCheckRequest.loadBalancerName()));
        }
        if ((healthCheck = configureHealthCheckRequest.healthCheck()) != null) {
            if (healthCheck.target() != null) {
                request.addParameter("HealthCheck.Target", StringConversion.fromString((String)healthCheck.target()));
            }
            if (healthCheck.interval() != null) {
                request.addParameter("HealthCheck.Interval", StringConversion.fromInteger((Integer)healthCheck.interval()));
            }
            if (healthCheck.timeout() != null) {
                request.addParameter("HealthCheck.Timeout", StringConversion.fromInteger((Integer)healthCheck.timeout()));
            }
            if (healthCheck.unhealthyThreshold() != null) {
                request.addParameter("HealthCheck.UnhealthyThreshold", StringConversion.fromInteger((Integer)healthCheck.unhealthyThreshold()));
            }
            if (healthCheck.healthyThreshold() != null) {
                request.addParameter("HealthCheck.HealthyThreshold", StringConversion.fromInteger((Integer)healthCheck.healthyThreshold()));
            }
        }
        return request;
    }
}

