/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.elasticloadbalancing.model.ElasticLoadBalancingRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.LoadBalancerAttributes;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyLoadBalancerAttributesRequest
extends ElasticLoadBalancingRequest
implements ToCopyableBuilder<Builder, ModifyLoadBalancerAttributesRequest> {
    private final String loadBalancerName;
    private final LoadBalancerAttributes loadBalancerAttributes;

    private ModifyLoadBalancerAttributesRequest(BuilderImpl builder) {
        super(builder);
        this.loadBalancerName = builder.loadBalancerName;
        this.loadBalancerAttributes = builder.loadBalancerAttributes;
    }

    public String loadBalancerName() {
        return this.loadBalancerName;
    }

    public LoadBalancerAttributes loadBalancerAttributes() {
        return this.loadBalancerAttributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.loadBalancerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.loadBalancerAttributes());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyLoadBalancerAttributesRequest)) {
            return false;
        }
        ModifyLoadBalancerAttributesRequest other = (ModifyLoadBalancerAttributesRequest)((Object)obj);
        return Objects.equals(this.loadBalancerName(), other.loadBalancerName()) && Objects.equals(this.loadBalancerAttributes(), other.loadBalancerAttributes());
    }

    public String toString() {
        return ToString.builder((String)"ModifyLoadBalancerAttributesRequest").add("LoadBalancerName", (Object)this.loadBalancerName()).add("LoadBalancerAttributes", (Object)this.loadBalancerAttributes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LoadBalancerName": {
                return Optional.ofNullable(clazz.cast(this.loadBalancerName()));
            }
            case "LoadBalancerAttributes": {
                return Optional.ofNullable(clazz.cast(this.loadBalancerAttributes()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ElasticLoadBalancingRequest.BuilderImpl
    implements Builder {
        private String loadBalancerName;
        private LoadBalancerAttributes loadBalancerAttributes;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyLoadBalancerAttributesRequest model) {
            super(model);
            this.loadBalancerName(model.loadBalancerName);
            this.loadBalancerAttributes(model.loadBalancerAttributes);
        }

        public final String getLoadBalancerName() {
            return this.loadBalancerName;
        }

        @Override
        public final Builder loadBalancerName(String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
            return this;
        }

        public final void setLoadBalancerName(String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
        }

        public final LoadBalancerAttributes.Builder getLoadBalancerAttributes() {
            return this.loadBalancerAttributes != null ? this.loadBalancerAttributes.toBuilder() : null;
        }

        @Override
        public final Builder loadBalancerAttributes(LoadBalancerAttributes loadBalancerAttributes) {
            this.loadBalancerAttributes = loadBalancerAttributes;
            return this;
        }

        public final void setLoadBalancerAttributes(LoadBalancerAttributes.BuilderImpl loadBalancerAttributes) {
            this.loadBalancerAttributes = loadBalancerAttributes != null ? loadBalancerAttributes.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyLoadBalancerAttributesRequest build() {
            return new ModifyLoadBalancerAttributesRequest(this);
        }
    }

    public static interface Builder
    extends ElasticLoadBalancingRequest.Builder,
    CopyableBuilder<Builder, ModifyLoadBalancerAttributesRequest> {
        public Builder loadBalancerName(String var1);

        public Builder loadBalancerAttributes(LoadBalancerAttributes var1);

        default public Builder loadBalancerAttributes(Consumer<LoadBalancerAttributes.Builder> loadBalancerAttributes) {
            return this.loadBalancerAttributes((LoadBalancerAttributes)((LoadBalancerAttributes.Builder)LoadBalancerAttributes.builder().applyMutation(loadBalancerAttributes)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

