/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Instance
implements ToCopyableBuilder<Builder, Instance> {
    private final String instanceId;

    private Instance(BuilderImpl builder) {
        this.instanceId = builder.instanceId;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Instance)) {
            return false;
        }
        Instance other = (Instance)obj;
        return Objects.equals(this.instanceId(), other.instanceId());
    }

    public String toString() {
        return ToString.builder((String)"Instance").add("InstanceId", (Object)this.instanceId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String instanceId;

        private BuilderImpl() {
        }

        private BuilderImpl(Instance model) {
            this.instanceId(model.instanceId);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public Instance build() {
            return new Instance(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Instance> {
        public Builder instanceId(String var1);
    }
}

