/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.elasticloadbalancing.model.ElasticLoadBalancingResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.LoadBalancerDescription;
import software.amazon.awssdk.services.elasticloadbalancing.model.LoadBalancerDescriptionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeLoadBalancersResponse
extends ElasticLoadBalancingResponse
implements ToCopyableBuilder<Builder, DescribeLoadBalancersResponse> {
    private final List<LoadBalancerDescription> loadBalancerDescriptions;
    private final String nextMarker;

    private DescribeLoadBalancersResponse(BuilderImpl builder) {
        super(builder);
        this.loadBalancerDescriptions = builder.loadBalancerDescriptions;
        this.nextMarker = builder.nextMarker;
    }

    public List<LoadBalancerDescription> loadBalancerDescriptions() {
        return this.loadBalancerDescriptions;
    }

    public String nextMarker() {
        return this.nextMarker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.loadBalancerDescriptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextMarker());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLoadBalancersResponse)) {
            return false;
        }
        DescribeLoadBalancersResponse other = (DescribeLoadBalancersResponse)((Object)obj);
        return Objects.equals(this.loadBalancerDescriptions(), other.loadBalancerDescriptions()) && Objects.equals(this.nextMarker(), other.nextMarker());
    }

    public String toString() {
        return ToString.builder((String)"DescribeLoadBalancersResponse").add("LoadBalancerDescriptions", this.loadBalancerDescriptions()).add("NextMarker", (Object)this.nextMarker()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LoadBalancerDescriptions": {
                return Optional.ofNullable(clazz.cast(this.loadBalancerDescriptions()));
            }
            case "NextMarker": {
                return Optional.ofNullable(clazz.cast(this.nextMarker()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ElasticLoadBalancingResponse.BuilderImpl
    implements Builder {
        private List<LoadBalancerDescription> loadBalancerDescriptions = DefaultSdkAutoConstructList.getInstance();
        private String nextMarker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLoadBalancersResponse model) {
            super(model);
            this.loadBalancerDescriptions(model.loadBalancerDescriptions);
            this.nextMarker(model.nextMarker);
        }

        public final Collection<LoadBalancerDescription.Builder> getLoadBalancerDescriptions() {
            return this.loadBalancerDescriptions != null ? (Collection)this.loadBalancerDescriptions.stream().map(LoadBalancerDescription::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder loadBalancerDescriptions(Collection<LoadBalancerDescription> loadBalancerDescriptions) {
            this.loadBalancerDescriptions = LoadBalancerDescriptionsCopier.copy(loadBalancerDescriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loadBalancerDescriptions(LoadBalancerDescription ... loadBalancerDescriptions) {
            this.loadBalancerDescriptions(Arrays.asList(loadBalancerDescriptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loadBalancerDescriptions(Consumer<LoadBalancerDescription.Builder> ... loadBalancerDescriptions) {
            this.loadBalancerDescriptions(Stream.of(loadBalancerDescriptions).map(c -> (LoadBalancerDescription)((LoadBalancerDescription.Builder)LoadBalancerDescription.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setLoadBalancerDescriptions(Collection<LoadBalancerDescription.BuilderImpl> loadBalancerDescriptions) {
            this.loadBalancerDescriptions = LoadBalancerDescriptionsCopier.copyFromBuilder(loadBalancerDescriptions);
        }

        public final String getNextMarker() {
            return this.nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        @Override
        public DescribeLoadBalancersResponse build() {
            return new DescribeLoadBalancersResponse(this);
        }
    }

    public static interface Builder
    extends ElasticLoadBalancingResponse.Builder,
    CopyableBuilder<Builder, DescribeLoadBalancersResponse> {
        public Builder loadBalancerDescriptions(Collection<LoadBalancerDescription> var1);

        public Builder loadBalancerDescriptions(LoadBalancerDescription ... var1);

        public Builder loadBalancerDescriptions(Consumer<LoadBalancerDescription.Builder> ... var1);

        public Builder nextMarker(String var1);
    }
}

