/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.elasticloadbalancing.model.ElasticLoadBalancingResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.PolicyDescription;
import software.amazon.awssdk.services.elasticloadbalancing.model.PolicyDescriptionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeLoadBalancerPoliciesResponse
extends ElasticLoadBalancingResponse
implements ToCopyableBuilder<Builder, DescribeLoadBalancerPoliciesResponse> {
    private final List<PolicyDescription> policyDescriptions;

    private DescribeLoadBalancerPoliciesResponse(BuilderImpl builder) {
        super(builder);
        this.policyDescriptions = builder.policyDescriptions;
    }

    public List<PolicyDescription> policyDescriptions() {
        return this.policyDescriptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.policyDescriptions());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLoadBalancerPoliciesResponse)) {
            return false;
        }
        DescribeLoadBalancerPoliciesResponse other = (DescribeLoadBalancerPoliciesResponse)((Object)obj);
        return Objects.equals(this.policyDescriptions(), other.policyDescriptions());
    }

    public String toString() {
        return ToString.builder((String)"DescribeLoadBalancerPoliciesResponse").add("PolicyDescriptions", this.policyDescriptions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PolicyDescriptions": {
                return Optional.ofNullable(clazz.cast(this.policyDescriptions()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ElasticLoadBalancingResponse.BuilderImpl
    implements Builder {
        private List<PolicyDescription> policyDescriptions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLoadBalancerPoliciesResponse model) {
            super(model);
            this.policyDescriptions(model.policyDescriptions);
        }

        public final Collection<PolicyDescription.Builder> getPolicyDescriptions() {
            return this.policyDescriptions != null ? (Collection)this.policyDescriptions.stream().map(PolicyDescription::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder policyDescriptions(Collection<PolicyDescription> policyDescriptions) {
            this.policyDescriptions = PolicyDescriptionsCopier.copy(policyDescriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyDescriptions(PolicyDescription ... policyDescriptions) {
            this.policyDescriptions(Arrays.asList(policyDescriptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyDescriptions(Consumer<PolicyDescription.Builder> ... policyDescriptions) {
            this.policyDescriptions(Stream.of(policyDescriptions).map(c -> (PolicyDescription)((PolicyDescription.Builder)PolicyDescription.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPolicyDescriptions(Collection<PolicyDescription.BuilderImpl> policyDescriptions) {
            this.policyDescriptions = PolicyDescriptionsCopier.copyFromBuilder(policyDescriptions);
        }

        @Override
        public DescribeLoadBalancerPoliciesResponse build() {
            return new DescribeLoadBalancerPoliciesResponse(this);
        }
    }

    public static interface Builder
    extends ElasticLoadBalancingResponse.Builder,
    CopyableBuilder<Builder, DescribeLoadBalancerPoliciesResponse> {
        public Builder policyDescriptions(Collection<PolicyDescription> var1);

        public Builder policyDescriptions(PolicyDescription ... var1);

        public Builder policyDescriptions(Consumer<PolicyDescription.Builder> ... var1);
    }
}

