/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.elasticloadbalancing.model.ElasticLoadBalancingResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.SecurityGroupsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ApplySecurityGroupsToLoadBalancerResponse
extends ElasticLoadBalancingResponse
implements ToCopyableBuilder<Builder, ApplySecurityGroupsToLoadBalancerResponse> {
    private final List<String> securityGroups;

    private ApplySecurityGroupsToLoadBalancerResponse(BuilderImpl builder) {
        super(builder);
        this.securityGroups = builder.securityGroups;
    }

    public List<String> securityGroups() {
        return this.securityGroups;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.securityGroups());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplySecurityGroupsToLoadBalancerResponse)) {
            return false;
        }
        ApplySecurityGroupsToLoadBalancerResponse other = (ApplySecurityGroupsToLoadBalancerResponse)((Object)obj);
        return Objects.equals(this.securityGroups(), other.securityGroups());
    }

    public String toString() {
        return ToString.builder((String)"ApplySecurityGroupsToLoadBalancerResponse").add("SecurityGroups", this.securityGroups()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SecurityGroups": {
                return Optional.ofNullable(clazz.cast(this.securityGroups()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ElasticLoadBalancingResponse.BuilderImpl
    implements Builder {
        private List<String> securityGroups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ApplySecurityGroupsToLoadBalancerResponse model) {
            super(model);
            this.securityGroups(model.securityGroups);
        }

        public final Collection<String> getSecurityGroups() {
            return this.securityGroups;
        }

        @Override
        public final Builder securityGroups(Collection<String> securityGroups) {
            this.securityGroups = SecurityGroupsCopier.copy(securityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(String ... securityGroups) {
            this.securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        public final void setSecurityGroups(Collection<String> securityGroups) {
            this.securityGroups = SecurityGroupsCopier.copy(securityGroups);
        }

        @Override
        public ApplySecurityGroupsToLoadBalancerResponse build() {
            return new ApplySecurityGroupsToLoadBalancerResponse(this);
        }
    }

    public static interface Builder
    extends ElasticLoadBalancingResponse.Builder,
    CopyableBuilder<Builder, ApplySecurityGroupsToLoadBalancerResponse> {
        public Builder securityGroups(Collection<String> var1);

        public Builder securityGroups(String ... var1);
    }
}

