/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.http.response.DefaultErrorResponseHandler;
import software.amazon.awssdk.awscore.http.response.StaxResponseHandler;
import software.amazon.awssdk.awscore.protocol.xml.StandardErrorUnmarshaller;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.internal.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.ElasticLoadBalancingAsyncClient;
import software.amazon.awssdk.services.elasticloadbalancing.model.AddTagsRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.AddTagsResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.ApplySecurityGroupsToLoadBalancerRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.ApplySecurityGroupsToLoadBalancerResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.AttachLoadBalancerToSubnetsRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.AttachLoadBalancerToSubnetsResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.ConfigureHealthCheckRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.ConfigureHealthCheckResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.CreateAppCookieStickinessPolicyRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.CreateAppCookieStickinessPolicyResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.CreateLbCookieStickinessPolicyRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.CreateLbCookieStickinessPolicyResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.CreateLoadBalancerListenersRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.CreateLoadBalancerListenersResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.CreateLoadBalancerPolicyRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.CreateLoadBalancerPolicyResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.CreateLoadBalancerRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.CreateLoadBalancerResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.DeleteLoadBalancerListenersRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.DeleteLoadBalancerListenersResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.DeleteLoadBalancerPolicyRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.DeleteLoadBalancerPolicyResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.DeleteLoadBalancerRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.DeleteLoadBalancerResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.DeregisterInstancesFromLoadBalancerRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.DeregisterInstancesFromLoadBalancerResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.DescribeAccountLimitsRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.DescribeAccountLimitsResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.DescribeInstanceHealthRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.DescribeInstanceHealthResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.DescribeLoadBalancerAttributesRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.DescribeLoadBalancerAttributesResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.DescribeLoadBalancerPoliciesRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.DescribeLoadBalancerPoliciesResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.DescribeLoadBalancerPolicyTypesRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.DescribeLoadBalancerPolicyTypesResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.DescribeLoadBalancersRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.DescribeLoadBalancersResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.DescribeTagsRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.DescribeTagsResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.DetachLoadBalancerFromSubnetsRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.DetachLoadBalancerFromSubnetsResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.DisableAvailabilityZonesForLoadBalancerRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.DisableAvailabilityZonesForLoadBalancerResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.ElasticLoadBalancingException;
import software.amazon.awssdk.services.elasticloadbalancing.model.ElasticLoadBalancingRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.EnableAvailabilityZonesForLoadBalancerRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.EnableAvailabilityZonesForLoadBalancerResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.ModifyLoadBalancerAttributesRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.ModifyLoadBalancerAttributesResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.RegisterInstancesWithLoadBalancerRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.RegisterInstancesWithLoadBalancerResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.RemoveTagsRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.RemoveTagsResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.SetLoadBalancerListenerSslCertificateRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.SetLoadBalancerListenerSslCertificateResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.SetLoadBalancerPoliciesForBackendServerRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.SetLoadBalancerPoliciesForBackendServerResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.SetLoadBalancerPoliciesOfListenerRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.SetLoadBalancerPoliciesOfListenerResponse;
import software.amazon.awssdk.services.elasticloadbalancing.paginators.DescribeLoadBalancersPublisher;
import software.amazon.awssdk.services.elasticloadbalancing.transform.AddTagsRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.AddTagsResponseUnmarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.ApplySecurityGroupsToLoadBalancerRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.ApplySecurityGroupsToLoadBalancerResponseUnmarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.AttachLoadBalancerToSubnetsRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.AttachLoadBalancerToSubnetsResponseUnmarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.CertificateNotFoundExceptionUnmarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.ConfigureHealthCheckRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.ConfigureHealthCheckResponseUnmarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.CreateAppCookieStickinessPolicyRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.CreateAppCookieStickinessPolicyResponseUnmarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.CreateLbCookieStickinessPolicyRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.CreateLbCookieStickinessPolicyResponseUnmarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.CreateLoadBalancerListenersRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.CreateLoadBalancerListenersResponseUnmarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.CreateLoadBalancerPolicyRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.CreateLoadBalancerPolicyResponseUnmarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.CreateLoadBalancerRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.CreateLoadBalancerResponseUnmarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.DeleteLoadBalancerListenersRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.DeleteLoadBalancerListenersResponseUnmarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.DeleteLoadBalancerPolicyRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.DeleteLoadBalancerPolicyResponseUnmarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.DeleteLoadBalancerRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.DeleteLoadBalancerResponseUnmarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.DependencyThrottleExceptionUnmarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.DeregisterInstancesFromLoadBalancerRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.DeregisterInstancesFromLoadBalancerResponseUnmarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.DescribeAccountLimitsRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.DescribeAccountLimitsResponseUnmarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.DescribeInstanceHealthRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.DescribeInstanceHealthResponseUnmarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.DescribeLoadBalancerAttributesRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.DescribeLoadBalancerAttributesResponseUnmarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.DescribeLoadBalancerPoliciesRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.DescribeLoadBalancerPoliciesResponseUnmarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.DescribeLoadBalancerPolicyTypesRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.DescribeLoadBalancerPolicyTypesResponseUnmarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.DescribeLoadBalancersRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.DescribeLoadBalancersResponseUnmarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.DescribeTagsRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.DescribeTagsResponseUnmarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.DetachLoadBalancerFromSubnetsRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.DetachLoadBalancerFromSubnetsResponseUnmarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.DisableAvailabilityZonesForLoadBalancerRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.DisableAvailabilityZonesForLoadBalancerResponseUnmarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.DuplicateListenerExceptionUnmarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.DuplicateLoadBalancerNameExceptionUnmarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.DuplicatePolicyNameExceptionUnmarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.DuplicateTagKeysExceptionUnmarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.EnableAvailabilityZonesForLoadBalancerRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.EnableAvailabilityZonesForLoadBalancerResponseUnmarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.InvalidConfigurationRequestExceptionUnmarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.InvalidInstanceExceptionUnmarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.InvalidSchemeExceptionUnmarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.InvalidSecurityGroupExceptionUnmarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.InvalidSubnetExceptionUnmarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.ListenerNotFoundExceptionUnmarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.LoadBalancerAttributeNotFoundExceptionUnmarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.LoadBalancerNotFoundExceptionUnmarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.ModifyLoadBalancerAttributesRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.ModifyLoadBalancerAttributesResponseUnmarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.OperationNotPermittedExceptionUnmarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.PolicyNotFoundExceptionUnmarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.PolicyTypeNotFoundExceptionUnmarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.RegisterInstancesWithLoadBalancerRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.RegisterInstancesWithLoadBalancerResponseUnmarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.RemoveTagsRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.RemoveTagsResponseUnmarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.SetLoadBalancerListenerSslCertificateRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.SetLoadBalancerListenerSslCertificateResponseUnmarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.SetLoadBalancerPoliciesForBackendServerRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.SetLoadBalancerPoliciesForBackendServerResponseUnmarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.SetLoadBalancerPoliciesOfListenerRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.SetLoadBalancerPoliciesOfListenerResponseUnmarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.SubnetNotFoundExceptionUnmarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.TooManyLoadBalancersExceptionUnmarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.TooManyPoliciesExceptionUnmarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.TooManyTagsExceptionUnmarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.UnsupportedProtocolExceptionUnmarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

@SdkInternalApi
final class DefaultElasticLoadBalancingAsyncClient
implements ElasticLoadBalancingAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultElasticLoadBalancingAsyncClient.class);
    private final AsyncClientHandler clientHandler;
    private final List<Unmarshaller<AwsServiceException, Node>> exceptionUnmarshallers;

    protected DefaultElasticLoadBalancingAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.exceptionUnmarshallers = this.init();
    }

    public final String serviceName() {
        return "elasticloadbalancing";
    }

    @Override
    public CompletableFuture<AddTagsResponse> addTags(AddTagsRequest addTagsRequest) {
        try {
            StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new AddTagsResponseUnmarshaller());
            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new AddTagsRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)addTagsRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ApplySecurityGroupsToLoadBalancerResponse> applySecurityGroupsToLoadBalancer(ApplySecurityGroupsToLoadBalancerRequest applySecurityGroupsToLoadBalancerRequest) {
        try {
            StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new ApplySecurityGroupsToLoadBalancerResponseUnmarshaller());
            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new ApplySecurityGroupsToLoadBalancerRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)applySecurityGroupsToLoadBalancerRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<AttachLoadBalancerToSubnetsResponse> attachLoadBalancerToSubnets(AttachLoadBalancerToSubnetsRequest attachLoadBalancerToSubnetsRequest) {
        try {
            StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new AttachLoadBalancerToSubnetsResponseUnmarshaller());
            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new AttachLoadBalancerToSubnetsRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)attachLoadBalancerToSubnetsRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ConfigureHealthCheckResponse> configureHealthCheck(ConfigureHealthCheckRequest configureHealthCheckRequest) {
        try {
            StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new ConfigureHealthCheckResponseUnmarshaller());
            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new ConfigureHealthCheckRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)configureHealthCheckRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateAppCookieStickinessPolicyResponse> createAppCookieStickinessPolicy(CreateAppCookieStickinessPolicyRequest createAppCookieStickinessPolicyRequest) {
        try {
            StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new CreateAppCookieStickinessPolicyResponseUnmarshaller());
            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new CreateAppCookieStickinessPolicyRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)createAppCookieStickinessPolicyRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateLbCookieStickinessPolicyResponse> createLBCookieStickinessPolicy(CreateLbCookieStickinessPolicyRequest createLbCookieStickinessPolicyRequest) {
        try {
            StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new CreateLbCookieStickinessPolicyResponseUnmarshaller());
            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new CreateLbCookieStickinessPolicyRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)createLbCookieStickinessPolicyRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateLoadBalancerResponse> createLoadBalancer(CreateLoadBalancerRequest createLoadBalancerRequest) {
        try {
            StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new CreateLoadBalancerResponseUnmarshaller());
            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new CreateLoadBalancerRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)createLoadBalancerRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateLoadBalancerListenersResponse> createLoadBalancerListeners(CreateLoadBalancerListenersRequest createLoadBalancerListenersRequest) {
        try {
            StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new CreateLoadBalancerListenersResponseUnmarshaller());
            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new CreateLoadBalancerListenersRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)createLoadBalancerListenersRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateLoadBalancerPolicyResponse> createLoadBalancerPolicy(CreateLoadBalancerPolicyRequest createLoadBalancerPolicyRequest) {
        try {
            StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new CreateLoadBalancerPolicyResponseUnmarshaller());
            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new CreateLoadBalancerPolicyRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)createLoadBalancerPolicyRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteLoadBalancerResponse> deleteLoadBalancer(DeleteLoadBalancerRequest deleteLoadBalancerRequest) {
        try {
            StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new DeleteLoadBalancerResponseUnmarshaller());
            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DeleteLoadBalancerRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)deleteLoadBalancerRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteLoadBalancerListenersResponse> deleteLoadBalancerListeners(DeleteLoadBalancerListenersRequest deleteLoadBalancerListenersRequest) {
        try {
            StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new DeleteLoadBalancerListenersResponseUnmarshaller());
            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DeleteLoadBalancerListenersRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)deleteLoadBalancerListenersRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteLoadBalancerPolicyResponse> deleteLoadBalancerPolicy(DeleteLoadBalancerPolicyRequest deleteLoadBalancerPolicyRequest) {
        try {
            StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new DeleteLoadBalancerPolicyResponseUnmarshaller());
            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DeleteLoadBalancerPolicyRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)deleteLoadBalancerPolicyRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeregisterInstancesFromLoadBalancerResponse> deregisterInstancesFromLoadBalancer(DeregisterInstancesFromLoadBalancerRequest deregisterInstancesFromLoadBalancerRequest) {
        try {
            StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new DeregisterInstancesFromLoadBalancerResponseUnmarshaller());
            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DeregisterInstancesFromLoadBalancerRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)deregisterInstancesFromLoadBalancerRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeAccountLimitsResponse> describeAccountLimits(DescribeAccountLimitsRequest describeAccountLimitsRequest) {
        try {
            StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new DescribeAccountLimitsResponseUnmarshaller());
            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DescribeAccountLimitsRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)describeAccountLimitsRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeInstanceHealthResponse> describeInstanceHealth(DescribeInstanceHealthRequest describeInstanceHealthRequest) {
        try {
            StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new DescribeInstanceHealthResponseUnmarshaller());
            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DescribeInstanceHealthRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)describeInstanceHealthRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeLoadBalancerAttributesResponse> describeLoadBalancerAttributes(DescribeLoadBalancerAttributesRequest describeLoadBalancerAttributesRequest) {
        try {
            StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new DescribeLoadBalancerAttributesResponseUnmarshaller());
            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DescribeLoadBalancerAttributesRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)describeLoadBalancerAttributesRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeLoadBalancerPoliciesResponse> describeLoadBalancerPolicies(DescribeLoadBalancerPoliciesRequest describeLoadBalancerPoliciesRequest) {
        try {
            StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new DescribeLoadBalancerPoliciesResponseUnmarshaller());
            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DescribeLoadBalancerPoliciesRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)describeLoadBalancerPoliciesRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeLoadBalancerPolicyTypesResponse> describeLoadBalancerPolicyTypes(DescribeLoadBalancerPolicyTypesRequest describeLoadBalancerPolicyTypesRequest) {
        try {
            StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new DescribeLoadBalancerPolicyTypesResponseUnmarshaller());
            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DescribeLoadBalancerPolicyTypesRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)describeLoadBalancerPolicyTypesRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeLoadBalancersResponse> describeLoadBalancers(DescribeLoadBalancersRequest describeLoadBalancersRequest) {
        try {
            StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new DescribeLoadBalancersResponseUnmarshaller());
            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DescribeLoadBalancersRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)describeLoadBalancersRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public DescribeLoadBalancersPublisher describeLoadBalancersPaginator(DescribeLoadBalancersRequest describeLoadBalancersRequest) {
        return new DescribeLoadBalancersPublisher(this, this.applyPaginatorUserAgent(describeLoadBalancersRequest));
    }

    @Override
    public CompletableFuture<DescribeTagsResponse> describeTags(DescribeTagsRequest describeTagsRequest) {
        try {
            StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new DescribeTagsResponseUnmarshaller());
            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DescribeTagsRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)describeTagsRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DetachLoadBalancerFromSubnetsResponse> detachLoadBalancerFromSubnets(DetachLoadBalancerFromSubnetsRequest detachLoadBalancerFromSubnetsRequest) {
        try {
            StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new DetachLoadBalancerFromSubnetsResponseUnmarshaller());
            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DetachLoadBalancerFromSubnetsRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)detachLoadBalancerFromSubnetsRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DisableAvailabilityZonesForLoadBalancerResponse> disableAvailabilityZonesForLoadBalancer(DisableAvailabilityZonesForLoadBalancerRequest disableAvailabilityZonesForLoadBalancerRequest) {
        try {
            StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new DisableAvailabilityZonesForLoadBalancerResponseUnmarshaller());
            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DisableAvailabilityZonesForLoadBalancerRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)disableAvailabilityZonesForLoadBalancerRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<EnableAvailabilityZonesForLoadBalancerResponse> enableAvailabilityZonesForLoadBalancer(EnableAvailabilityZonesForLoadBalancerRequest enableAvailabilityZonesForLoadBalancerRequest) {
        try {
            StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new EnableAvailabilityZonesForLoadBalancerResponseUnmarshaller());
            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new EnableAvailabilityZonesForLoadBalancerRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)enableAvailabilityZonesForLoadBalancerRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ModifyLoadBalancerAttributesResponse> modifyLoadBalancerAttributes(ModifyLoadBalancerAttributesRequest modifyLoadBalancerAttributesRequest) {
        try {
            StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new ModifyLoadBalancerAttributesResponseUnmarshaller());
            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new ModifyLoadBalancerAttributesRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)modifyLoadBalancerAttributesRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RegisterInstancesWithLoadBalancerResponse> registerInstancesWithLoadBalancer(RegisterInstancesWithLoadBalancerRequest registerInstancesWithLoadBalancerRequest) {
        try {
            StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new RegisterInstancesWithLoadBalancerResponseUnmarshaller());
            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new RegisterInstancesWithLoadBalancerRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)registerInstancesWithLoadBalancerRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RemoveTagsResponse> removeTags(RemoveTagsRequest removeTagsRequest) {
        try {
            StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new RemoveTagsResponseUnmarshaller());
            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new RemoveTagsRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)removeTagsRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<SetLoadBalancerListenerSslCertificateResponse> setLoadBalancerListenerSSLCertificate(SetLoadBalancerListenerSslCertificateRequest setLoadBalancerListenerSslCertificateRequest) {
        try {
            StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new SetLoadBalancerListenerSslCertificateResponseUnmarshaller());
            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new SetLoadBalancerListenerSslCertificateRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)setLoadBalancerListenerSslCertificateRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<SetLoadBalancerPoliciesForBackendServerResponse> setLoadBalancerPoliciesForBackendServer(SetLoadBalancerPoliciesForBackendServerRequest setLoadBalancerPoliciesForBackendServerRequest) {
        try {
            StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new SetLoadBalancerPoliciesForBackendServerResponseUnmarshaller());
            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new SetLoadBalancerPoliciesForBackendServerRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)setLoadBalancerPoliciesForBackendServerRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<SetLoadBalancerPoliciesOfListenerResponse> setLoadBalancerPoliciesOfListener(SetLoadBalancerPoliciesOfListenerRequest setLoadBalancerPoliciesOfListenerRequest) {
        try {
            StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new SetLoadBalancerPoliciesOfListenerResponseUnmarshaller());
            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new SetLoadBalancerPoliciesOfListenerRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)setLoadBalancerPoliciesOfListenerRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    public void close() {
        this.clientHandler.close();
    }

    private List<Unmarshaller<AwsServiceException, Node>> init() {
        ArrayList<Unmarshaller<AwsServiceException, Node>> unmarshallers = new ArrayList<Unmarshaller<AwsServiceException, Node>>();
        unmarshallers.add((Unmarshaller<AwsServiceException, Node>)new UnsupportedProtocolExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AwsServiceException, Node>)new LoadBalancerAttributeNotFoundExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AwsServiceException, Node>)new LoadBalancerNotFoundExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AwsServiceException, Node>)new TooManyLoadBalancersExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AwsServiceException, Node>)new InvalidConfigurationRequestExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AwsServiceException, Node>)new InvalidSecurityGroupExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AwsServiceException, Node>)new DuplicateLoadBalancerNameExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AwsServiceException, Node>)new DependencyThrottleExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AwsServiceException, Node>)new OperationNotPermittedExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AwsServiceException, Node>)new PolicyNotFoundExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AwsServiceException, Node>)new CertificateNotFoundExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AwsServiceException, Node>)new DuplicateTagKeysExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AwsServiceException, Node>)new TooManyTagsExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AwsServiceException, Node>)new ListenerNotFoundExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AwsServiceException, Node>)new TooManyPoliciesExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AwsServiceException, Node>)new DuplicatePolicyNameExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AwsServiceException, Node>)new SubnetNotFoundExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AwsServiceException, Node>)new DuplicateListenerExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AwsServiceException, Node>)new InvalidSchemeExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AwsServiceException, Node>)new PolicyTypeNotFoundExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AwsServiceException, Node>)new InvalidSubnetExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AwsServiceException, Node>)new InvalidInstanceExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AwsServiceException, Node>)new StandardErrorUnmarshaller(ElasticLoadBalancingException.class));
        return unmarshallers;
    }

    private <T extends ElasticLoadBalancingRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.0.0-preview-12").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((ElasticLoadBalancingRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }
}

