/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.elasticloadbalancing.model.SetLoadBalancerPoliciesOfListenerRequest;

public class SetLoadBalancerPoliciesOfListenerRequestMarshaller
implements Marshaller<Request<SetLoadBalancerPoliciesOfListenerRequest>, SetLoadBalancerPoliciesOfListenerRequest> {
    public Request<SetLoadBalancerPoliciesOfListenerRequest> marshall(SetLoadBalancerPoliciesOfListenerRequest setLoadBalancerPoliciesOfListenerRequest) {
        if (setLoadBalancerPoliciesOfListenerRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)setLoadBalancerPoliciesOfListenerRequest, "ElasticLoadBalancingClient");
        request.addParameter("Action", "SetLoadBalancerPoliciesOfListener");
        request.addParameter("Version", "2012-06-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (setLoadBalancerPoliciesOfListenerRequest.loadBalancerName() != null) {
            request.addParameter("LoadBalancerName", StringConversion.fromString((String)setLoadBalancerPoliciesOfListenerRequest.loadBalancerName()));
        }
        if (setLoadBalancerPoliciesOfListenerRequest.loadBalancerPort() != null) {
            request.addParameter("LoadBalancerPort", StringConversion.fromInteger((Integer)setLoadBalancerPoliciesOfListenerRequest.loadBalancerPort()));
        }
        if (setLoadBalancerPoliciesOfListenerRequest.policyNames().isEmpty() && !(setLoadBalancerPoliciesOfListenerRequest.policyNames() instanceof SdkAutoConstructList)) {
            request.addParameter("PolicyNames", "");
        } else if (!setLoadBalancerPoliciesOfListenerRequest.policyNames().isEmpty() && !(setLoadBalancerPoliciesOfListenerRequest.policyNames() instanceof SdkAutoConstructList)) {
            List<String> policyNamesList = setLoadBalancerPoliciesOfListenerRequest.policyNames();
            int policyNamesListIndex = 1;
            for (String policyNamesListValue : policyNamesList) {
                if (policyNamesListValue != null) {
                    request.addParameter("PolicyNames.member." + policyNamesListIndex, StringConversion.fromString((String)policyNamesListValue));
                }
                ++policyNamesListIndex;
            }
        }
        return request;
    }
}

