/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.elasticloadbalancing.model.Instance;
import software.amazon.awssdk.services.elasticloadbalancing.model.RegisterInstancesWithLoadBalancerRequest;

public class RegisterInstancesWithLoadBalancerRequestMarshaller
implements Marshaller<Request<RegisterInstancesWithLoadBalancerRequest>, RegisterInstancesWithLoadBalancerRequest> {
    public Request<RegisterInstancesWithLoadBalancerRequest> marshall(RegisterInstancesWithLoadBalancerRequest registerInstancesWithLoadBalancerRequest) {
        if (registerInstancesWithLoadBalancerRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)registerInstancesWithLoadBalancerRequest, "ElasticLoadBalancingClient");
        request.addParameter("Action", "RegisterInstancesWithLoadBalancer");
        request.addParameter("Version", "2012-06-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (registerInstancesWithLoadBalancerRequest.loadBalancerName() != null) {
            request.addParameter("LoadBalancerName", StringConversion.fromString((String)registerInstancesWithLoadBalancerRequest.loadBalancerName()));
        }
        if (registerInstancesWithLoadBalancerRequest.instances().isEmpty() && !(registerInstancesWithLoadBalancerRequest.instances() instanceof SdkAutoConstructList)) {
            request.addParameter("Instances", "");
        } else if (!registerInstancesWithLoadBalancerRequest.instances().isEmpty() && !(registerInstancesWithLoadBalancerRequest.instances() instanceof SdkAutoConstructList)) {
            List<Instance> instancesList = registerInstancesWithLoadBalancerRequest.instances();
            int instancesListIndex = 1;
            for (Instance instancesListValue : instancesList) {
                if (instancesListValue.instanceId() != null) {
                    request.addParameter("Instances.member." + instancesListIndex + ".InstanceId", StringConversion.fromString((String)instancesListValue.instanceId()));
                }
                ++instancesListIndex;
            }
        }
        return request;
    }
}

