/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.elasticloadbalancing.model.AccessLog;
import software.amazon.awssdk.services.elasticloadbalancing.model.AdditionalAttribute;
import software.amazon.awssdk.services.elasticloadbalancing.model.ConnectionDraining;
import software.amazon.awssdk.services.elasticloadbalancing.model.ConnectionSettings;
import software.amazon.awssdk.services.elasticloadbalancing.model.CrossZoneLoadBalancing;
import software.amazon.awssdk.services.elasticloadbalancing.model.LoadBalancerAttributes;
import software.amazon.awssdk.services.elasticloadbalancing.model.ModifyLoadBalancerAttributesRequest;

public class ModifyLoadBalancerAttributesRequestMarshaller
implements Marshaller<Request<ModifyLoadBalancerAttributesRequest>, ModifyLoadBalancerAttributesRequest> {
    public Request<ModifyLoadBalancerAttributesRequest> marshall(ModifyLoadBalancerAttributesRequest modifyLoadBalancerAttributesRequest) {
        LoadBalancerAttributes loadBalancerAttributes;
        if (modifyLoadBalancerAttributesRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)modifyLoadBalancerAttributesRequest, "ElasticLoadBalancingClient");
        request.addParameter("Action", "ModifyLoadBalancerAttributes");
        request.addParameter("Version", "2012-06-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyLoadBalancerAttributesRequest.loadBalancerName() != null) {
            request.addParameter("LoadBalancerName", StringConversion.fromString((String)modifyLoadBalancerAttributesRequest.loadBalancerName()));
        }
        if ((loadBalancerAttributes = modifyLoadBalancerAttributesRequest.loadBalancerAttributes()) != null) {
            ConnectionSettings connectionSettings;
            ConnectionDraining connectionDraining;
            AccessLog accessLog;
            CrossZoneLoadBalancing crossZoneLoadBalancing = loadBalancerAttributes.crossZoneLoadBalancing();
            if (crossZoneLoadBalancing != null && crossZoneLoadBalancing.enabled() != null) {
                request.addParameter("LoadBalancerAttributes.CrossZoneLoadBalancing.Enabled", StringConversion.fromBoolean((Boolean)crossZoneLoadBalancing.enabled()));
            }
            if ((accessLog = loadBalancerAttributes.accessLog()) != null) {
                if (accessLog.enabled() != null) {
                    request.addParameter("LoadBalancerAttributes.AccessLog.Enabled", StringConversion.fromBoolean((Boolean)accessLog.enabled()));
                }
                if (accessLog.s3BucketName() != null) {
                    request.addParameter("LoadBalancerAttributes.AccessLog.S3BucketName", StringConversion.fromString((String)accessLog.s3BucketName()));
                }
                if (accessLog.emitInterval() != null) {
                    request.addParameter("LoadBalancerAttributes.AccessLog.EmitInterval", StringConversion.fromInteger((Integer)accessLog.emitInterval()));
                }
                if (accessLog.s3BucketPrefix() != null) {
                    request.addParameter("LoadBalancerAttributes.AccessLog.S3BucketPrefix", StringConversion.fromString((String)accessLog.s3BucketPrefix()));
                }
            }
            if ((connectionDraining = loadBalancerAttributes.connectionDraining()) != null) {
                if (connectionDraining.enabled() != null) {
                    request.addParameter("LoadBalancerAttributes.ConnectionDraining.Enabled", StringConversion.fromBoolean((Boolean)connectionDraining.enabled()));
                }
                if (connectionDraining.timeout() != null) {
                    request.addParameter("LoadBalancerAttributes.ConnectionDraining.Timeout", StringConversion.fromInteger((Integer)connectionDraining.timeout()));
                }
            }
            if ((connectionSettings = loadBalancerAttributes.connectionSettings()) != null && connectionSettings.idleTimeout() != null) {
                request.addParameter("LoadBalancerAttributes.ConnectionSettings.IdleTimeout", StringConversion.fromInteger((Integer)connectionSettings.idleTimeout()));
            }
            if (loadBalancerAttributes.additionalAttributes().isEmpty() && !(loadBalancerAttributes.additionalAttributes() instanceof SdkAutoConstructList)) {
                request.addParameter("LoadBalancerAttributes.AdditionalAttributes", "");
            } else if (!loadBalancerAttributes.additionalAttributes().isEmpty() && !(loadBalancerAttributes.additionalAttributes() instanceof SdkAutoConstructList)) {
                List<AdditionalAttribute> additionalAttributesList = loadBalancerAttributes.additionalAttributes();
                int additionalAttributesListIndex = 1;
                for (AdditionalAttribute additionalAttributesListValue : additionalAttributesList) {
                    if (additionalAttributesListValue.key() != null) {
                        request.addParameter("LoadBalancerAttributes.AdditionalAttributes.member." + additionalAttributesListIndex + ".Key", StringConversion.fromString((String)additionalAttributesListValue.key()));
                    }
                    if (additionalAttributesListValue.value() != null) {
                        request.addParameter("LoadBalancerAttributes.AdditionalAttributes.member." + additionalAttributesListIndex + ".Value", StringConversion.fromString((String)additionalAttributesListValue.value()));
                    }
                    ++additionalAttributesListIndex;
                }
            }
        }
        return request;
    }
}

