/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.elasticloadbalancing.model.DescribeLoadBalancerPolicyTypesRequest;

public class DescribeLoadBalancerPolicyTypesRequestMarshaller
implements Marshaller<Request<DescribeLoadBalancerPolicyTypesRequest>, DescribeLoadBalancerPolicyTypesRequest> {
    public Request<DescribeLoadBalancerPolicyTypesRequest> marshall(DescribeLoadBalancerPolicyTypesRequest describeLoadBalancerPolicyTypesRequest) {
        if (describeLoadBalancerPolicyTypesRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeLoadBalancerPolicyTypesRequest, "ElasticLoadBalancingClient");
        request.addParameter("Action", "DescribeLoadBalancerPolicyTypes");
        request.addParameter("Version", "2012-06-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeLoadBalancerPolicyTypesRequest.policyTypeNames().isEmpty() && !(describeLoadBalancerPolicyTypesRequest.policyTypeNames() instanceof SdkAutoConstructList)) {
            request.addParameter("PolicyTypeNames", "");
        } else if (!describeLoadBalancerPolicyTypesRequest.policyTypeNames().isEmpty() && !(describeLoadBalancerPolicyTypesRequest.policyTypeNames() instanceof SdkAutoConstructList)) {
            List<String> policyTypeNamesList = describeLoadBalancerPolicyTypesRequest.policyTypeNames();
            int policyTypeNamesListIndex = 1;
            for (String policyTypeNamesListValue : policyTypeNamesList) {
                if (policyTypeNamesListValue != null) {
                    request.addParameter("PolicyTypeNames.member." + policyTypeNamesListIndex, StringConversion.fromString((String)policyTypeNamesListValue));
                }
                ++policyTypeNamesListIndex;
            }
        }
        return request;
    }
}

