/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.elasticloadbalancing.model.DescribeInstanceHealthRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.Instance;

public class DescribeInstanceHealthRequestMarshaller
implements Marshaller<Request<DescribeInstanceHealthRequest>, DescribeInstanceHealthRequest> {
    public Request<DescribeInstanceHealthRequest> marshall(DescribeInstanceHealthRequest describeInstanceHealthRequest) {
        if (describeInstanceHealthRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeInstanceHealthRequest, "ElasticLoadBalancingClient");
        request.addParameter("Action", "DescribeInstanceHealth");
        request.addParameter("Version", "2012-06-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeInstanceHealthRequest.loadBalancerName() != null) {
            request.addParameter("LoadBalancerName", StringConversion.fromString((String)describeInstanceHealthRequest.loadBalancerName()));
        }
        if (describeInstanceHealthRequest.instances().isEmpty() && !(describeInstanceHealthRequest.instances() instanceof SdkAutoConstructList)) {
            request.addParameter("Instances", "");
        } else if (!describeInstanceHealthRequest.instances().isEmpty() && !(describeInstanceHealthRequest.instances() instanceof SdkAutoConstructList)) {
            List<Instance> instancesList = describeInstanceHealthRequest.instances();
            int instancesListIndex = 1;
            for (Instance instancesListValue : instancesList) {
                if (instancesListValue.instanceId() != null) {
                    request.addParameter("Instances.member." + instancesListIndex + ".InstanceId", StringConversion.fromString((String)instancesListValue.instanceId()));
                }
                ++instancesListIndex;
            }
        }
        return request;
    }
}

