/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.model.ConnectionSettings;

public class ConnectionSettingsUnmarshaller
implements Unmarshaller<ConnectionSettings, StaxUnmarshallerContext> {
    private static final ConnectionSettingsUnmarshaller INSTANCE = new ConnectionSettingsUnmarshaller();

    public ConnectionSettings unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        ConnectionSettings.Builder connectionSettings = ConnectionSettings.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (!context.testExpression("IdleTimeout", targetDepth)) continue;
                connectionSettings.idleTimeout(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (ConnectionSettings)connectionSettings.build();
    }

    public static ConnectionSettingsUnmarshaller getInstance() {
        return INSTANCE;
    }
}

