/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.elasticloadbalancing.model.ApplySecurityGroupsToLoadBalancerRequest;

public class ApplySecurityGroupsToLoadBalancerRequestMarshaller
implements Marshaller<Request<ApplySecurityGroupsToLoadBalancerRequest>, ApplySecurityGroupsToLoadBalancerRequest> {
    public Request<ApplySecurityGroupsToLoadBalancerRequest> marshall(ApplySecurityGroupsToLoadBalancerRequest applySecurityGroupsToLoadBalancerRequest) {
        if (applySecurityGroupsToLoadBalancerRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)applySecurityGroupsToLoadBalancerRequest, "ElasticLoadBalancingClient");
        request.addParameter("Action", "ApplySecurityGroupsToLoadBalancer");
        request.addParameter("Version", "2012-06-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (applySecurityGroupsToLoadBalancerRequest.loadBalancerName() != null) {
            request.addParameter("LoadBalancerName", StringConversion.fromString((String)applySecurityGroupsToLoadBalancerRequest.loadBalancerName()));
        }
        if (applySecurityGroupsToLoadBalancerRequest.securityGroups().isEmpty() && !(applySecurityGroupsToLoadBalancerRequest.securityGroups() instanceof SdkAutoConstructList)) {
            request.addParameter("SecurityGroups", "");
        } else if (!applySecurityGroupsToLoadBalancerRequest.securityGroups().isEmpty() && !(applySecurityGroupsToLoadBalancerRequest.securityGroups() instanceof SdkAutoConstructList)) {
            List<String> securityGroupsList = applySecurityGroupsToLoadBalancerRequest.securityGroups();
            int securityGroupsListIndex = 1;
            for (String securityGroupsListValue : securityGroupsList) {
                if (securityGroupsListValue != null) {
                    request.addParameter("SecurityGroups.member." + securityGroupsListIndex, StringConversion.fromString((String)securityGroupsListValue));
                }
                ++securityGroupsListIndex;
            }
        }
        return request;
    }
}

