/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.elasticloadbalancing.model.AddTagsRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.Tag;

public class AddTagsRequestMarshaller
implements Marshaller<Request<AddTagsRequest>, AddTagsRequest> {
    public Request<AddTagsRequest> marshall(AddTagsRequest addTagsRequest) {
        if (addTagsRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)addTagsRequest, "ElasticLoadBalancingClient");
        request.addParameter("Action", "AddTags");
        request.addParameter("Version", "2012-06-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (addTagsRequest.loadBalancerNames().isEmpty() && !(addTagsRequest.loadBalancerNames() instanceof SdkAutoConstructList)) {
            request.addParameter("LoadBalancerNames", "");
        } else if (!addTagsRequest.loadBalancerNames().isEmpty() && !(addTagsRequest.loadBalancerNames() instanceof SdkAutoConstructList)) {
            List<String> loadBalancerNamesList = addTagsRequest.loadBalancerNames();
            int loadBalancerNamesListIndex = 1;
            for (String loadBalancerNamesListValue : loadBalancerNamesList) {
                if (loadBalancerNamesListValue != null) {
                    request.addParameter("LoadBalancerNames.member." + loadBalancerNamesListIndex, StringConversion.fromString((String)loadBalancerNamesListValue));
                }
                ++loadBalancerNamesListIndex;
            }
        }
        if (addTagsRequest.tags().isEmpty() && !(addTagsRequest.tags() instanceof SdkAutoConstructList)) {
            request.addParameter("Tags", "");
        } else if (!addTagsRequest.tags().isEmpty() && !(addTagsRequest.tags() instanceof SdkAutoConstructList)) {
            List<Tag> tagsList = addTagsRequest.tags();
            int tagsListIndex = 1;
            for (Tag tagsListValue : tagsList) {
                if (tagsListValue.key() != null) {
                    request.addParameter("Tags.member." + tagsListIndex + ".Key", StringConversion.fromString((String)tagsListValue.key()));
                }
                if (tagsListValue.value() != null) {
                    request.addParameter("Tags.member." + tagsListIndex + ".Value", StringConversion.fromString((String)tagsListValue.value()));
                }
                ++tagsListIndex;
            }
        }
        return request;
    }
}

