/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.elasticloadbalancing.model.ElasticLoadBalancingResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.Instance;
import software.amazon.awssdk.services.elasticloadbalancing.model.InstancesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RegisterInstancesWithLoadBalancerResponse
extends ElasticLoadBalancingResponse
implements ToCopyableBuilder<Builder, RegisterInstancesWithLoadBalancerResponse> {
    private final List<Instance> instances;

    private RegisterInstancesWithLoadBalancerResponse(BuilderImpl builder) {
        super(builder);
        this.instances = builder.instances;
    }

    public List<Instance> instances() {
        return this.instances;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instances());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterInstancesWithLoadBalancerResponse)) {
            return false;
        }
        RegisterInstancesWithLoadBalancerResponse other = (RegisterInstancesWithLoadBalancerResponse)((Object)obj);
        return Objects.equals(this.instances(), other.instances());
    }

    public String toString() {
        return ToString.builder((String)"RegisterInstancesWithLoadBalancerResponse").add("Instances", this.instances()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Instances": {
                return Optional.ofNullable(clazz.cast(this.instances()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ElasticLoadBalancingResponse.BuilderImpl
    implements Builder {
        private List<Instance> instances = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterInstancesWithLoadBalancerResponse model) {
            super(model);
            this.instances(model.instances);
        }

        public final Collection<Instance.Builder> getInstances() {
            return this.instances != null ? (Collection)this.instances.stream().map(Instance::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder instances(Collection<Instance> instances) {
            this.instances = InstancesCopier.copy(instances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instances(Instance ... instances) {
            this.instances(Arrays.asList(instances));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instances(Consumer<Instance.Builder> ... instances) {
            this.instances(Stream.of(instances).map(c -> (Instance)((Instance.Builder)Instance.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setInstances(Collection<Instance.BuilderImpl> instances) {
            this.instances = InstancesCopier.copyFromBuilder(instances);
        }

        @Override
        public RegisterInstancesWithLoadBalancerResponse build() {
            return new RegisterInstancesWithLoadBalancerResponse(this);
        }
    }

    public static interface Builder
    extends ElasticLoadBalancingResponse.Builder,
    CopyableBuilder<Builder, RegisterInstancesWithLoadBalancerResponse> {
        public Builder instances(Collection<Instance> var1);

        public Builder instances(Instance ... var1);

        public Builder instances(Consumer<Instance.Builder> ... var1);
    }
}

