/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InstanceState
implements ToCopyableBuilder<Builder, InstanceState> {
    private final String instanceId;
    private final String state;
    private final String reasonCode;
    private final String description;

    private InstanceState(BuilderImpl builder) {
        this.instanceId = builder.instanceId;
        this.state = builder.state;
        this.reasonCode = builder.reasonCode;
        this.description = builder.description;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public String state() {
        return this.state;
    }

    public String reasonCode() {
        return this.reasonCode;
    }

    public String description() {
        return this.description;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.state());
        hashCode = 31 * hashCode + Objects.hashCode(this.reasonCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceState)) {
            return false;
        }
        InstanceState other = (InstanceState)obj;
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.state(), other.state()) && Objects.equals(this.reasonCode(), other.reasonCode()) && Objects.equals(this.description(), other.description());
    }

    public String toString() {
        return ToString.builder((String)"InstanceState").add("InstanceId", (Object)this.instanceId()).add("State", (Object)this.state()).add("ReasonCode", (Object)this.reasonCode()).add("Description", (Object)this.description()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.state()));
            }
            case "ReasonCode": {
                return Optional.ofNullable(clazz.cast(this.reasonCode()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String instanceId;
        private String state;
        private String reasonCode;
        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceState model) {
            this.instanceId(model.instanceId);
            this.state(model.state);
            this.reasonCode(model.reasonCode);
            this.description(model.description);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getReasonCode() {
            return this.reasonCode;
        }

        @Override
        public final Builder reasonCode(String reasonCode) {
            this.reasonCode = reasonCode;
            return this;
        }

        public final void setReasonCode(String reasonCode) {
            this.reasonCode = reasonCode;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public InstanceState build() {
            return new InstanceState(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, InstanceState> {
        public Builder instanceId(String var1);

        public Builder state(String var1);

        public Builder reasonCode(String var1);

        public Builder description(String var1);
    }
}

