/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.elasticloadbalancing.model.ElasticLoadBalancingResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.SubnetsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DetachLoadBalancerFromSubnetsResponse
extends ElasticLoadBalancingResponse
implements ToCopyableBuilder<Builder, DetachLoadBalancerFromSubnetsResponse> {
    private final List<String> subnets;

    private DetachLoadBalancerFromSubnetsResponse(BuilderImpl builder) {
        super(builder);
        this.subnets = builder.subnets;
    }

    public List<String> subnets() {
        return this.subnets;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.subnets());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetachLoadBalancerFromSubnetsResponse)) {
            return false;
        }
        DetachLoadBalancerFromSubnetsResponse other = (DetachLoadBalancerFromSubnetsResponse)((Object)obj);
        return Objects.equals(this.subnets(), other.subnets());
    }

    public String toString() {
        return ToString.builder((String)"DetachLoadBalancerFromSubnetsResponse").add("Subnets", this.subnets()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Subnets": {
                return Optional.ofNullable(clazz.cast(this.subnets()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ElasticLoadBalancingResponse.BuilderImpl
    implements Builder {
        private List<String> subnets = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DetachLoadBalancerFromSubnetsResponse model) {
            super(model);
            this.subnets(model.subnets);
        }

        public final Collection<String> getSubnets() {
            return this.subnets;
        }

        @Override
        public final Builder subnets(Collection<String> subnets) {
            this.subnets = SubnetsCopier.copy(subnets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnets(String ... subnets) {
            this.subnets(Arrays.asList(subnets));
            return this;
        }

        public final void setSubnets(Collection<String> subnets) {
            this.subnets = SubnetsCopier.copy(subnets);
        }

        @Override
        public DetachLoadBalancerFromSubnetsResponse build() {
            return new DetachLoadBalancerFromSubnetsResponse(this);
        }
    }

    public static interface Builder
    extends ElasticLoadBalancingResponse.Builder,
    CopyableBuilder<Builder, DetachLoadBalancerFromSubnetsResponse> {
        public Builder subnets(Collection<String> var1);

        public Builder subnets(String ... var1);
    }
}

