/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.elasticloadbalancing.model.PolicyAttributeDescription;
import software.amazon.awssdk.services.elasticloadbalancing.model.PolicyAttributeDescriptionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PolicyDescription
implements ToCopyableBuilder<Builder, PolicyDescription> {
    private final String policyName;
    private final String policyTypeName;
    private final List<PolicyAttributeDescription> policyAttributeDescriptions;

    private PolicyDescription(BuilderImpl builder) {
        this.policyName = builder.policyName;
        this.policyTypeName = builder.policyTypeName;
        this.policyAttributeDescriptions = builder.policyAttributeDescriptions;
    }

    public String policyName() {
        return this.policyName;
    }

    public String policyTypeName() {
        return this.policyTypeName;
    }

    public List<PolicyAttributeDescription> policyAttributeDescriptions() {
        return this.policyAttributeDescriptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.policyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyTypeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyAttributeDescriptions());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PolicyDescription)) {
            return false;
        }
        PolicyDescription other = (PolicyDescription)obj;
        return Objects.equals(this.policyName(), other.policyName()) && Objects.equals(this.policyTypeName(), other.policyTypeName()) && Objects.equals(this.policyAttributeDescriptions(), other.policyAttributeDescriptions());
    }

    public String toString() {
        return ToString.builder((String)"PolicyDescription").add("PolicyName", (Object)this.policyName()).add("PolicyTypeName", (Object)this.policyTypeName()).add("PolicyAttributeDescriptions", this.policyAttributeDescriptions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PolicyName": {
                return Optional.of(clazz.cast(this.policyName()));
            }
            case "PolicyTypeName": {
                return Optional.of(clazz.cast(this.policyTypeName()));
            }
            case "PolicyAttributeDescriptions": {
                return Optional.of(clazz.cast(this.policyAttributeDescriptions()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String policyName;
        private String policyTypeName;
        private List<PolicyAttributeDescription> policyAttributeDescriptions;

        private BuilderImpl() {
        }

        private BuilderImpl(PolicyDescription model) {
            this.policyName(model.policyName);
            this.policyTypeName(model.policyTypeName);
            this.policyAttributeDescriptions(model.policyAttributeDescriptions);
        }

        public final String getPolicyName() {
            return this.policyName;
        }

        @Override
        public final Builder policyName(String policyName) {
            this.policyName = policyName;
            return this;
        }

        public final void setPolicyName(String policyName) {
            this.policyName = policyName;
        }

        public final String getPolicyTypeName() {
            return this.policyTypeName;
        }

        @Override
        public final Builder policyTypeName(String policyTypeName) {
            this.policyTypeName = policyTypeName;
            return this;
        }

        public final void setPolicyTypeName(String policyTypeName) {
            this.policyTypeName = policyTypeName;
        }

        public final Collection<PolicyAttributeDescription.Builder> getPolicyAttributeDescriptions() {
            return this.policyAttributeDescriptions != null ? (Collection)this.policyAttributeDescriptions.stream().map(PolicyAttributeDescription::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder policyAttributeDescriptions(Collection<PolicyAttributeDescription> policyAttributeDescriptions) {
            this.policyAttributeDescriptions = PolicyAttributeDescriptionsCopier.copy(policyAttributeDescriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyAttributeDescriptions(PolicyAttributeDescription ... policyAttributeDescriptions) {
            this.policyAttributeDescriptions(Arrays.asList(policyAttributeDescriptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyAttributeDescriptions(Consumer<PolicyAttributeDescription.Builder> ... policyAttributeDescriptions) {
            this.policyAttributeDescriptions(Stream.of(policyAttributeDescriptions).map(c -> (PolicyAttributeDescription)((PolicyAttributeDescription.Builder)PolicyAttributeDescription.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPolicyAttributeDescriptions(Collection<PolicyAttributeDescription.BuilderImpl> policyAttributeDescriptions) {
            this.policyAttributeDescriptions = PolicyAttributeDescriptionsCopier.copyFromBuilder(policyAttributeDescriptions);
        }

        public PolicyDescription build() {
            return new PolicyDescription(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PolicyDescription> {
        public Builder policyName(String var1);

        public Builder policyTypeName(String var1);

        public Builder policyAttributeDescriptions(Collection<PolicyAttributeDescription> var1);

        public Builder policyAttributeDescriptions(PolicyAttributeDescription ... var1);

        public Builder policyAttributeDescriptions(Consumer<PolicyAttributeDescription.Builder> ... var1);
    }
}

