/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.elasticloadbalancing.model.ElasticLoadBalancingResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.InstanceState;
import software.amazon.awssdk.services.elasticloadbalancing.model.InstanceStatesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeInstanceHealthResponse
extends ElasticLoadBalancingResponse
implements ToCopyableBuilder<Builder, DescribeInstanceHealthResponse> {
    private final List<InstanceState> instanceStates;

    private DescribeInstanceHealthResponse(BuilderImpl builder) {
        super(builder);
        this.instanceStates = builder.instanceStates;
    }

    public List<InstanceState> instanceStates() {
        return this.instanceStates;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceStates());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInstanceHealthResponse)) {
            return false;
        }
        DescribeInstanceHealthResponse other = (DescribeInstanceHealthResponse)((Object)obj);
        return Objects.equals(this.instanceStates(), other.instanceStates());
    }

    public String toString() {
        return ToString.builder((String)"DescribeInstanceHealthResponse").add("InstanceStates", this.instanceStates()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceStates": {
                return Optional.of(clazz.cast(this.instanceStates()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ElasticLoadBalancingResponse.BuilderImpl
    implements Builder {
        private List<InstanceState> instanceStates;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInstanceHealthResponse model) {
            super(model);
            this.instanceStates(model.instanceStates);
        }

        public final Collection<InstanceState.Builder> getInstanceStates() {
            return this.instanceStates != null ? (Collection)this.instanceStates.stream().map(InstanceState::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder instanceStates(Collection<InstanceState> instanceStates) {
            this.instanceStates = InstanceStatesCopier.copy(instanceStates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceStates(InstanceState ... instanceStates) {
            this.instanceStates(Arrays.asList(instanceStates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceStates(Consumer<InstanceState.Builder> ... instanceStates) {
            this.instanceStates(Stream.of(instanceStates).map(c -> (InstanceState)((InstanceState.Builder)InstanceState.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setInstanceStates(Collection<InstanceState.BuilderImpl> instanceStates) {
            this.instanceStates = InstanceStatesCopier.copyFromBuilder(instanceStates);
        }

        @Override
        public DescribeInstanceHealthResponse build() {
            return new DescribeInstanceHealthResponse(this);
        }
    }

    public static interface Builder
    extends ElasticLoadBalancingResponse.Builder,
    CopyableBuilder<Builder, DescribeInstanceHealthResponse> {
        public Builder instanceStates(Collection<InstanceState> var1);

        public Builder instanceStates(InstanceState ... var1);

        public Builder instanceStates(Consumer<InstanceState.Builder> ... var1);
    }
}

