/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.elasticloadbalancing.model.SetLoadBalancerPoliciesOfListenerRequest;
import software.amazon.awssdk.util.StringUtils;

public class SetLoadBalancerPoliciesOfListenerRequestMarshaller
implements Marshaller<Request<SetLoadBalancerPoliciesOfListenerRequest>, SetLoadBalancerPoliciesOfListenerRequest> {
    public Request<SetLoadBalancerPoliciesOfListenerRequest> marshall(SetLoadBalancerPoliciesOfListenerRequest setLoadBalancerPoliciesOfListenerRequest) {
        SdkInternalList policyNamesList;
        if (setLoadBalancerPoliciesOfListenerRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)setLoadBalancerPoliciesOfListenerRequest, "ElasticLoadBalancingClient");
        request.addParameter("Action", "SetLoadBalancerPoliciesOfListener");
        request.addParameter("Version", "2012-06-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (setLoadBalancerPoliciesOfListenerRequest.loadBalancerName() != null) {
            request.addParameter("LoadBalancerName", StringUtils.fromString((String)setLoadBalancerPoliciesOfListenerRequest.loadBalancerName()));
        }
        if (setLoadBalancerPoliciesOfListenerRequest.loadBalancerPort() != null) {
            request.addParameter("LoadBalancerPort", StringUtils.fromInteger((Integer)setLoadBalancerPoliciesOfListenerRequest.loadBalancerPort()));
        }
        if ((policyNamesList = (SdkInternalList)setLoadBalancerPoliciesOfListenerRequest.policyNames()).isEmpty()) {
            request.addParameter("PolicyNames", "");
        }
        if (!policyNamesList.isEmpty() || !policyNamesList.isAutoConstruct()) {
            int policyNamesListIndex = 1;
            for (String policyNamesListValue : policyNamesList) {
                if (policyNamesListValue != null) {
                    request.addParameter("PolicyNames.member." + policyNamesListIndex, StringUtils.fromString((String)policyNamesListValue));
                }
                ++policyNamesListIndex;
            }
        }
        return request;
    }
}

