/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.model.AppCookieStickinessPolicy;
import software.amazon.awssdk.services.elasticloadbalancing.model.LBCookieStickinessPolicy;
import software.amazon.awssdk.services.elasticloadbalancing.model.Policies;
import software.amazon.awssdk.services.elasticloadbalancing.transform.AppCookieStickinessPolicyUnmarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.LBCookieStickinessPolicyUnmarshaller;

public class PoliciesUnmarshaller
implements Unmarshaller<Policies, StaxUnmarshallerContext> {
    private static PoliciesUnmarshaller INSTANCE;

    public Policies unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        Policies.Builder policies = Policies.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("AppCookieStickinessPolicies", targetDepth)) {
                    policies.appCookieStickinessPolicies(new ArrayList<AppCookieStickinessPolicy>());
                    continue;
                }
                if (context.testExpression("AppCookieStickinessPolicies/member", targetDepth)) {
                    policies.appCookieStickinessPolicies(AppCookieStickinessPolicyUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("LBCookieStickinessPolicies", targetDepth)) {
                    policies.lbCookieStickinessPolicies(new ArrayList<LBCookieStickinessPolicy>());
                    continue;
                }
                if (context.testExpression("LBCookieStickinessPolicies/member", targetDepth)) {
                    policies.lbCookieStickinessPolicies(LBCookieStickinessPolicyUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("OtherPolicies", targetDepth)) {
                    policies.otherPolicies(new ArrayList<String>());
                    continue;
                }
                if (!context.testExpression("OtherPolicies/member", targetDepth)) continue;
                policies.otherPolicies(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (Policies)policies.build();
    }

    public static PoliciesUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new PoliciesUnmarshaller();
        }
        return INSTANCE;
    }
}

