/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.model.BackendServerDescription;
import software.amazon.awssdk.services.elasticloadbalancing.model.Instance;
import software.amazon.awssdk.services.elasticloadbalancing.model.ListenerDescription;
import software.amazon.awssdk.services.elasticloadbalancing.model.LoadBalancerDescription;
import software.amazon.awssdk.services.elasticloadbalancing.transform.BackendServerDescriptionUnmarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.HealthCheckUnmarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.InstanceUnmarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.ListenerDescriptionUnmarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.PoliciesUnmarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.SourceSecurityGroupUnmarshaller;

public class LoadBalancerDescriptionUnmarshaller
implements Unmarshaller<LoadBalancerDescription, StaxUnmarshallerContext> {
    private static LoadBalancerDescriptionUnmarshaller INSTANCE;

    public LoadBalancerDescription unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        LoadBalancerDescription.Builder loadBalancerDescription = LoadBalancerDescription.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("LoadBalancerName", targetDepth)) {
                    loadBalancerDescription.loadBalancerName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("DNSName", targetDepth)) {
                    loadBalancerDescription.dnsName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("CanonicalHostedZoneName", targetDepth)) {
                    loadBalancerDescription.canonicalHostedZoneName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("CanonicalHostedZoneNameID", targetDepth)) {
                    loadBalancerDescription.canonicalHostedZoneNameID(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ListenerDescriptions", targetDepth)) {
                    loadBalancerDescription.listenerDescriptions(new ArrayList<ListenerDescription>());
                    continue;
                }
                if (context.testExpression("ListenerDescriptions/member", targetDepth)) {
                    loadBalancerDescription.listenerDescriptions(ListenerDescriptionUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Policies", targetDepth)) {
                    loadBalancerDescription.policies(PoliciesUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("BackendServerDescriptions", targetDepth)) {
                    loadBalancerDescription.backendServerDescriptions(new ArrayList<BackendServerDescription>());
                    continue;
                }
                if (context.testExpression("BackendServerDescriptions/member", targetDepth)) {
                    loadBalancerDescription.backendServerDescriptions(BackendServerDescriptionUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("AvailabilityZones", targetDepth)) {
                    loadBalancerDescription.availabilityZones(new ArrayList<String>());
                    continue;
                }
                if (context.testExpression("AvailabilityZones/member", targetDepth)) {
                    loadBalancerDescription.availabilityZones(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Subnets", targetDepth)) {
                    loadBalancerDescription.subnets(new ArrayList<String>());
                    continue;
                }
                if (context.testExpression("Subnets/member", targetDepth)) {
                    loadBalancerDescription.subnets(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("VPCId", targetDepth)) {
                    loadBalancerDescription.vpcId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Instances", targetDepth)) {
                    loadBalancerDescription.instances(new ArrayList<Instance>());
                    continue;
                }
                if (context.testExpression("Instances/member", targetDepth)) {
                    loadBalancerDescription.instances(InstanceUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("HealthCheck", targetDepth)) {
                    loadBalancerDescription.healthCheck(HealthCheckUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("SourceSecurityGroup", targetDepth)) {
                    loadBalancerDescription.sourceSecurityGroup(SourceSecurityGroupUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("SecurityGroups", targetDepth)) {
                    loadBalancerDescription.securityGroups(new ArrayList<String>());
                    continue;
                }
                if (context.testExpression("SecurityGroups/member", targetDepth)) {
                    loadBalancerDescription.securityGroups(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("CreatedTime", targetDepth)) {
                    loadBalancerDescription.createdTime(SimpleTypeStaxUnmarshallers.DateUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("Scheme", targetDepth)) continue;
                loadBalancerDescription.scheme(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (LoadBalancerDescription)loadBalancerDescription.build();
    }

    public static LoadBalancerDescriptionUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new LoadBalancerDescriptionUnmarshaller();
        }
        return INSTANCE;
    }
}

