/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.elasticloadbalancing.model.DescribeLoadBalancersRequest;
import software.amazon.awssdk.util.StringUtils;

public class DescribeLoadBalancersRequestMarshaller
implements Marshaller<Request<DescribeLoadBalancersRequest>, DescribeLoadBalancersRequest> {
    public Request<DescribeLoadBalancersRequest> marshall(DescribeLoadBalancersRequest describeLoadBalancersRequest) {
        if (describeLoadBalancersRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeLoadBalancersRequest, "ElasticLoadBalancingClient");
        request.addParameter("Action", "DescribeLoadBalancers");
        request.addParameter("Version", "2012-06-01");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList loadBalancerNamesList = (SdkInternalList)describeLoadBalancersRequest.loadBalancerNames();
        if (!loadBalancerNamesList.isEmpty() || !loadBalancerNamesList.isAutoConstruct()) {
            int loadBalancerNamesListIndex = 1;
            for (String loadBalancerNamesListValue : loadBalancerNamesList) {
                if (loadBalancerNamesListValue != null) {
                    request.addParameter("LoadBalancerNames.member." + loadBalancerNamesListIndex, StringUtils.fromString((String)loadBalancerNamesListValue));
                }
                ++loadBalancerNamesListIndex;
            }
        }
        if (describeLoadBalancersRequest.marker() != null) {
            request.addParameter("Marker", StringUtils.fromString((String)describeLoadBalancersRequest.marker()));
        }
        if (describeLoadBalancersRequest.pageSize() != null) {
            request.addParameter("PageSize", StringUtils.fromInteger((Integer)describeLoadBalancersRequest.pageSize()));
        }
        return request;
    }
}

