/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.elasticloadbalancing.model.DeregisterInstancesFromLoadBalancerRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.Instance;
import software.amazon.awssdk.util.StringUtils;

public class DeregisterInstancesFromLoadBalancerRequestMarshaller
implements Marshaller<Request<DeregisterInstancesFromLoadBalancerRequest>, DeregisterInstancesFromLoadBalancerRequest> {
    public Request<DeregisterInstancesFromLoadBalancerRequest> marshall(DeregisterInstancesFromLoadBalancerRequest deregisterInstancesFromLoadBalancerRequest) {
        SdkInternalList instancesList;
        if (deregisterInstancesFromLoadBalancerRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)deregisterInstancesFromLoadBalancerRequest, "ElasticLoadBalancingClient");
        request.addParameter("Action", "DeregisterInstancesFromLoadBalancer");
        request.addParameter("Version", "2012-06-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (deregisterInstancesFromLoadBalancerRequest.loadBalancerName() != null) {
            request.addParameter("LoadBalancerName", StringUtils.fromString((String)deregisterInstancesFromLoadBalancerRequest.loadBalancerName()));
        }
        if (!(instancesList = (SdkInternalList)deregisterInstancesFromLoadBalancerRequest.instances()).isEmpty() || !instancesList.isAutoConstruct()) {
            int instancesListIndex = 1;
            for (Instance instancesListValue : instancesList) {
                if (instancesListValue.instanceId() != null) {
                    request.addParameter("Instances.member." + instancesListIndex + ".InstanceId", StringUtils.fromString((String)instancesListValue.instanceId()));
                }
                ++instancesListIndex;
            }
        }
        return request;
    }
}

