/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.elasticloadbalancing.model.PolicyAttributeTypeDescription;
import software.amazon.awssdk.services.elasticloadbalancing.model.PolicyAttributeTypeDescriptionsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PolicyTypeDescription
implements ToCopyableBuilder<Builder, PolicyTypeDescription> {
    private final String policyTypeName;
    private final String description;
    private final List<PolicyAttributeTypeDescription> policyAttributeTypeDescriptions;

    private PolicyTypeDescription(BuilderImpl builder) {
        this.policyTypeName = builder.policyTypeName;
        this.description = builder.description;
        this.policyAttributeTypeDescriptions = builder.policyAttributeTypeDescriptions;
    }

    public String policyTypeName() {
        return this.policyTypeName;
    }

    public String description() {
        return this.description;
    }

    public List<PolicyAttributeTypeDescription> policyAttributeTypeDescriptions() {
        return this.policyAttributeTypeDescriptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.policyTypeName() == null ? 0 : this.policyTypeName().hashCode());
        hashCode = 31 * hashCode + (this.description() == null ? 0 : this.description().hashCode());
        hashCode = 31 * hashCode + (this.policyAttributeTypeDescriptions() == null ? 0 : this.policyAttributeTypeDescriptions().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PolicyTypeDescription)) {
            return false;
        }
        PolicyTypeDescription other = (PolicyTypeDescription)obj;
        if (other.policyTypeName() == null ^ this.policyTypeName() == null) {
            return false;
        }
        if (other.policyTypeName() != null && !other.policyTypeName().equals(this.policyTypeName())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.policyAttributeTypeDescriptions() == null ^ this.policyAttributeTypeDescriptions() == null) {
            return false;
        }
        return other.policyAttributeTypeDescriptions() == null || other.policyAttributeTypeDescriptions().equals(this.policyAttributeTypeDescriptions());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.policyTypeName() != null) {
            sb.append("PolicyTypeName: ").append(this.policyTypeName()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.policyAttributeTypeDescriptions() != null) {
            sb.append("PolicyAttributeTypeDescriptions: ").append(this.policyAttributeTypeDescriptions()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String policyTypeName;
        private String description;
        private List<PolicyAttributeTypeDescription> policyAttributeTypeDescriptions = new SdkInternalList();

        private BuilderImpl() {
        }

        private BuilderImpl(PolicyTypeDescription model) {
            this.setPolicyTypeName(model.policyTypeName);
            this.setDescription(model.description);
            this.setPolicyAttributeTypeDescriptions(model.policyAttributeTypeDescriptions);
        }

        public final String getPolicyTypeName() {
            return this.policyTypeName;
        }

        @Override
        public final Builder policyTypeName(String policyTypeName) {
            this.policyTypeName = policyTypeName;
            return this;
        }

        public final void setPolicyTypeName(String policyTypeName) {
            this.policyTypeName = policyTypeName;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<PolicyAttributeTypeDescription> getPolicyAttributeTypeDescriptions() {
            return this.policyAttributeTypeDescriptions;
        }

        @Override
        public final Builder policyAttributeTypeDescriptions(Collection<PolicyAttributeTypeDescription> policyAttributeTypeDescriptions) {
            this.policyAttributeTypeDescriptions = PolicyAttributeTypeDescriptionsCopier.copy(policyAttributeTypeDescriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyAttributeTypeDescriptions(PolicyAttributeTypeDescription ... policyAttributeTypeDescriptions) {
            if (this.policyAttributeTypeDescriptions == null) {
                this.policyAttributeTypeDescriptions = new SdkInternalList(policyAttributeTypeDescriptions.length);
            }
            for (PolicyAttributeTypeDescription e : policyAttributeTypeDescriptions) {
                this.policyAttributeTypeDescriptions.add(e);
            }
            return this;
        }

        public final void setPolicyAttributeTypeDescriptions(Collection<PolicyAttributeTypeDescription> policyAttributeTypeDescriptions) {
            this.policyAttributeTypeDescriptions = PolicyAttributeTypeDescriptionsCopier.copy(policyAttributeTypeDescriptions);
        }

        @SafeVarargs
        public final void setPolicyAttributeTypeDescriptions(PolicyAttributeTypeDescription ... policyAttributeTypeDescriptions) {
            if (this.policyAttributeTypeDescriptions == null) {
                this.policyAttributeTypeDescriptions = new SdkInternalList(policyAttributeTypeDescriptions.length);
            }
            for (PolicyAttributeTypeDescription e : policyAttributeTypeDescriptions) {
                this.policyAttributeTypeDescriptions.add(e);
            }
        }

        public PolicyTypeDescription build() {
            return new PolicyTypeDescription(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PolicyTypeDescription> {
        public Builder policyTypeName(String var1);

        public Builder description(String var1);

        public Builder policyAttributeTypeDescriptions(Collection<PolicyAttributeTypeDescription> var1);

        public Builder policyAttributeTypeDescriptions(PolicyAttributeTypeDescription ... var1);
    }
}

