/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.elasticloadbalancing.model.PolicyDescription;
import software.amazon.awssdk.services.elasticloadbalancing.model.PolicyDescriptionsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeLoadBalancerPoliciesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeLoadBalancerPoliciesResponse> {
    private final List<PolicyDescription> policyDescriptions;

    private DescribeLoadBalancerPoliciesResponse(BuilderImpl builder) {
        this.policyDescriptions = builder.policyDescriptions;
    }

    public List<PolicyDescription> policyDescriptions() {
        return this.policyDescriptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.policyDescriptions() == null ? 0 : this.policyDescriptions().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLoadBalancerPoliciesResponse)) {
            return false;
        }
        DescribeLoadBalancerPoliciesResponse other = (DescribeLoadBalancerPoliciesResponse)((Object)obj);
        if (other.policyDescriptions() == null ^ this.policyDescriptions() == null) {
            return false;
        }
        return other.policyDescriptions() == null || other.policyDescriptions().equals(this.policyDescriptions());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.policyDescriptions() != null) {
            sb.append("PolicyDescriptions: ").append(this.policyDescriptions()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<PolicyDescription> policyDescriptions = new SdkInternalList();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLoadBalancerPoliciesResponse model) {
            this.setPolicyDescriptions(model.policyDescriptions);
        }

        public final Collection<PolicyDescription> getPolicyDescriptions() {
            return this.policyDescriptions;
        }

        @Override
        public final Builder policyDescriptions(Collection<PolicyDescription> policyDescriptions) {
            this.policyDescriptions = PolicyDescriptionsCopier.copy(policyDescriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyDescriptions(PolicyDescription ... policyDescriptions) {
            if (this.policyDescriptions == null) {
                this.policyDescriptions = new SdkInternalList(policyDescriptions.length);
            }
            for (PolicyDescription e : policyDescriptions) {
                this.policyDescriptions.add(e);
            }
            return this;
        }

        public final void setPolicyDescriptions(Collection<PolicyDescription> policyDescriptions) {
            this.policyDescriptions = PolicyDescriptionsCopier.copy(policyDescriptions);
        }

        @SafeVarargs
        public final void setPolicyDescriptions(PolicyDescription ... policyDescriptions) {
            if (this.policyDescriptions == null) {
                this.policyDescriptions = new SdkInternalList(policyDescriptions.length);
            }
            for (PolicyDescription e : policyDescriptions) {
                this.policyDescriptions.add(e);
            }
        }

        public DescribeLoadBalancerPoliciesResponse build() {
            return new DescribeLoadBalancerPoliciesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeLoadBalancerPoliciesResponse> {
        public Builder policyDescriptions(Collection<PolicyDescription> var1);

        public Builder policyDescriptions(PolicyDescription ... var1);
    }
}

