/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.elasticloadbalancing.model.Listener;
import software.amazon.awssdk.services.elasticloadbalancing.model.ListenersCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateLoadBalancerListenersRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CreateLoadBalancerListenersRequest> {
    private final String loadBalancerName;
    private final List<Listener> listeners;

    private CreateLoadBalancerListenersRequest(BuilderImpl builder) {
        this.loadBalancerName = builder.loadBalancerName;
        this.listeners = builder.listeners;
    }

    public String loadBalancerName() {
        return this.loadBalancerName;
    }

    public List<Listener> listeners() {
        return this.listeners;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.loadBalancerName() == null ? 0 : this.loadBalancerName().hashCode());
        hashCode = 31 * hashCode + (this.listeners() == null ? 0 : this.listeners().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLoadBalancerListenersRequest)) {
            return false;
        }
        CreateLoadBalancerListenersRequest other = (CreateLoadBalancerListenersRequest)((Object)obj);
        if (other.loadBalancerName() == null ^ this.loadBalancerName() == null) {
            return false;
        }
        if (other.loadBalancerName() != null && !other.loadBalancerName().equals(this.loadBalancerName())) {
            return false;
        }
        if (other.listeners() == null ^ this.listeners() == null) {
            return false;
        }
        return other.listeners() == null || other.listeners().equals(this.listeners());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.loadBalancerName() != null) {
            sb.append("LoadBalancerName: ").append(this.loadBalancerName()).append(",");
        }
        if (this.listeners() != null) {
            sb.append("Listeners: ").append(this.listeners()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String loadBalancerName;
        private List<Listener> listeners = new SdkInternalList();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLoadBalancerListenersRequest model) {
            this.setLoadBalancerName(model.loadBalancerName);
            this.setListeners(model.listeners);
        }

        public final String getLoadBalancerName() {
            return this.loadBalancerName;
        }

        @Override
        public final Builder loadBalancerName(String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
            return this;
        }

        public final void setLoadBalancerName(String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
        }

        public final Collection<Listener> getListeners() {
            return this.listeners;
        }

        @Override
        public final Builder listeners(Collection<Listener> listeners) {
            this.listeners = ListenersCopier.copy(listeners);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder listeners(Listener ... listeners) {
            if (this.listeners == null) {
                this.listeners = new SdkInternalList(listeners.length);
            }
            for (Listener e : listeners) {
                this.listeners.add(e);
            }
            return this;
        }

        public final void setListeners(Collection<Listener> listeners) {
            this.listeners = ListenersCopier.copy(listeners);
        }

        @SafeVarargs
        public final void setListeners(Listener ... listeners) {
            if (this.listeners == null) {
                this.listeners = new SdkInternalList(listeners.length);
            }
            for (Listener e : listeners) {
                this.listeners.add(e);
            }
        }

        public CreateLoadBalancerListenersRequest build() {
            return new CreateLoadBalancerListenersRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateLoadBalancerListenersRequest> {
        public Builder loadBalancerName(String var1);

        public Builder listeners(Collection<Listener> var1);

        public Builder listeners(Listener ... var1);
    }
}

