/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.query.AwsQueryProtocolFactory;
import software.amazon.awssdk.services.elasticbeanstalk.ElasticBeanstalkClient;
import software.amazon.awssdk.services.elasticbeanstalk.model.AbortEnvironmentUpdateRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.AbortEnvironmentUpdateResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.ApplyEnvironmentManagedActionRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.ApplyEnvironmentManagedActionResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.CheckDnsAvailabilityRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.CheckDnsAvailabilityResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.CodeBuildNotInServiceRegionException;
import software.amazon.awssdk.services.elasticbeanstalk.model.ComposeEnvironmentsRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.ComposeEnvironmentsResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.CreateApplicationRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.CreateApplicationResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.CreateApplicationVersionRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.CreateApplicationVersionResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.CreateConfigurationTemplateRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.CreateConfigurationTemplateResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.CreateEnvironmentRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.CreateEnvironmentResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.CreatePlatformVersionRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.CreatePlatformVersionResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.CreateStorageLocationRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.CreateStorageLocationResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.DeleteApplicationRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.DeleteApplicationResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.DeleteApplicationVersionRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.DeleteApplicationVersionResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.DeleteConfigurationTemplateRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.DeleteConfigurationTemplateResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.DeleteEnvironmentConfigurationRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.DeleteEnvironmentConfigurationResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.DeletePlatformVersionRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.DeletePlatformVersionResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeAccountAttributesRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeAccountAttributesResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeApplicationVersionsRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeApplicationVersionsResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeApplicationsRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeApplicationsResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeConfigurationOptionsRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeConfigurationOptionsResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeConfigurationSettingsRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeConfigurationSettingsResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentHealthRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentHealthResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentManagedActionHistoryRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentManagedActionHistoryResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentManagedActionsRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentManagedActionsResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentResourcesRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentResourcesResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentsRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentsResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEventsRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEventsResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeInstancesHealthRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeInstancesHealthResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribePlatformVersionRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribePlatformVersionResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.ElasticBeanstalkException;
import software.amazon.awssdk.services.elasticbeanstalk.model.ElasticBeanstalkRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.ElasticBeanstalkServiceException;
import software.amazon.awssdk.services.elasticbeanstalk.model.InsufficientPrivilegesException;
import software.amazon.awssdk.services.elasticbeanstalk.model.InvalidRequestException;
import software.amazon.awssdk.services.elasticbeanstalk.model.ListAvailableSolutionStacksRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.ListAvailableSolutionStacksResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.ListPlatformVersionsRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.ListPlatformVersionsResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.ManagedActionInvalidStateException;
import software.amazon.awssdk.services.elasticbeanstalk.model.OperationInProgressException;
import software.amazon.awssdk.services.elasticbeanstalk.model.PlatformVersionStillReferencedException;
import software.amazon.awssdk.services.elasticbeanstalk.model.RebuildEnvironmentRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.RebuildEnvironmentResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.RequestEnvironmentInfoRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.RequestEnvironmentInfoResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.ResourceNotFoundException;
import software.amazon.awssdk.services.elasticbeanstalk.model.ResourceTypeNotSupportedException;
import software.amazon.awssdk.services.elasticbeanstalk.model.RestartAppServerRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.RestartAppServerResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.RetrieveEnvironmentInfoRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.RetrieveEnvironmentInfoResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.S3LocationNotInServiceRegionException;
import software.amazon.awssdk.services.elasticbeanstalk.model.S3SubscriptionRequiredException;
import software.amazon.awssdk.services.elasticbeanstalk.model.SourceBundleDeletionException;
import software.amazon.awssdk.services.elasticbeanstalk.model.SwapEnvironmentCNAMEsResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.SwapEnvironmentCnamEsRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.TerminateEnvironmentRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.TerminateEnvironmentResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.TooManyApplicationVersionsException;
import software.amazon.awssdk.services.elasticbeanstalk.model.TooManyApplicationsException;
import software.amazon.awssdk.services.elasticbeanstalk.model.TooManyBucketsException;
import software.amazon.awssdk.services.elasticbeanstalk.model.TooManyConfigurationTemplatesException;
import software.amazon.awssdk.services.elasticbeanstalk.model.TooManyEnvironmentsException;
import software.amazon.awssdk.services.elasticbeanstalk.model.TooManyPlatformsException;
import software.amazon.awssdk.services.elasticbeanstalk.model.TooManyTagsException;
import software.amazon.awssdk.services.elasticbeanstalk.model.UpdateApplicationRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.UpdateApplicationResourceLifecycleRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.UpdateApplicationResourceLifecycleResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.UpdateApplicationResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.UpdateApplicationVersionRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.UpdateApplicationVersionResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.UpdateConfigurationTemplateRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.UpdateConfigurationTemplateResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.UpdateEnvironmentRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.UpdateEnvironmentResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.UpdateTagsForResourceRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.UpdateTagsForResourceResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.ValidateConfigurationSettingsRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.ValidateConfigurationSettingsResponse;
import software.amazon.awssdk.services.elasticbeanstalk.paginators.DescribeEventsIterable;
import software.amazon.awssdk.services.elasticbeanstalk.transform.AbortEnvironmentUpdateRequestMarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.ApplyEnvironmentManagedActionRequestMarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.CheckDnsAvailabilityRequestMarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.ComposeEnvironmentsRequestMarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.CreateApplicationRequestMarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.CreateApplicationVersionRequestMarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.CreateConfigurationTemplateRequestMarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.CreateEnvironmentRequestMarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.CreatePlatformVersionRequestMarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.CreateStorageLocationRequestMarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.DeleteApplicationRequestMarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.DeleteApplicationVersionRequestMarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.DeleteConfigurationTemplateRequestMarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.DeleteEnvironmentConfigurationRequestMarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.DeletePlatformVersionRequestMarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.DescribeAccountAttributesRequestMarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.DescribeApplicationVersionsRequestMarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.DescribeApplicationsRequestMarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.DescribeConfigurationOptionsRequestMarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.DescribeConfigurationSettingsRequestMarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.DescribeEnvironmentHealthRequestMarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.DescribeEnvironmentManagedActionHistoryRequestMarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.DescribeEnvironmentManagedActionsRequestMarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.DescribeEnvironmentResourcesRequestMarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.DescribeEnvironmentsRequestMarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.DescribeEventsRequestMarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.DescribeInstancesHealthRequestMarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.DescribePlatformVersionRequestMarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.ListAvailableSolutionStacksRequestMarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.ListPlatformVersionsRequestMarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.RebuildEnvironmentRequestMarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.RequestEnvironmentInfoRequestMarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.RestartAppServerRequestMarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.RetrieveEnvironmentInfoRequestMarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.SwapEnvironmentCnamEsRequestMarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.TerminateEnvironmentRequestMarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.UpdateApplicationRequestMarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.UpdateApplicationResourceLifecycleRequestMarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.UpdateApplicationVersionRequestMarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.UpdateConfigurationTemplateRequestMarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.UpdateEnvironmentRequestMarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.UpdateTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.ValidateConfigurationSettingsRequestMarshaller;

@SdkInternalApi
final class DefaultElasticBeanstalkClient
implements ElasticBeanstalkClient {
    private final SyncClientHandler clientHandler;
    private final AwsQueryProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultElasticBeanstalkClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init();
    }

    public final String serviceName() {
        return "elasticbeanstalk";
    }

    @Override
    public AbortEnvironmentUpdateResponse abortEnvironmentUpdate(AbortEnvironmentUpdateRequest abortEnvironmentUpdateRequest) throws InsufficientPrivilegesException, AwsServiceException, SdkClientException, ElasticBeanstalkException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(AbortEnvironmentUpdateResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (AbortEnvironmentUpdateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AbortEnvironmentUpdate").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)abortEnvironmentUpdateRequest).withMarshaller((Marshaller)new AbortEnvironmentUpdateRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ApplyEnvironmentManagedActionResponse applyEnvironmentManagedAction(ApplyEnvironmentManagedActionRequest applyEnvironmentManagedActionRequest) throws ElasticBeanstalkServiceException, ManagedActionInvalidStateException, AwsServiceException, SdkClientException, ElasticBeanstalkException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ApplyEnvironmentManagedActionResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (ApplyEnvironmentManagedActionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ApplyEnvironmentManagedAction").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)applyEnvironmentManagedActionRequest).withMarshaller((Marshaller)new ApplyEnvironmentManagedActionRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CheckDnsAvailabilityResponse checkDNSAvailability(CheckDnsAvailabilityRequest checkDnsAvailabilityRequest) throws AwsServiceException, SdkClientException, ElasticBeanstalkException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CheckDnsAvailabilityResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (CheckDnsAvailabilityResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CheckDNSAvailability").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)checkDnsAvailabilityRequest).withMarshaller((Marshaller)new CheckDnsAvailabilityRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ComposeEnvironmentsResponse composeEnvironments(ComposeEnvironmentsRequest composeEnvironmentsRequest) throws TooManyEnvironmentsException, InsufficientPrivilegesException, AwsServiceException, SdkClientException, ElasticBeanstalkException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ComposeEnvironmentsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (ComposeEnvironmentsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ComposeEnvironments").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)composeEnvironmentsRequest).withMarshaller((Marshaller)new ComposeEnvironmentsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CreateApplicationResponse createApplication(CreateApplicationRequest createApplicationRequest) throws TooManyApplicationsException, AwsServiceException, SdkClientException, ElasticBeanstalkException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateApplicationResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (CreateApplicationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateApplication").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createApplicationRequest).withMarshaller((Marshaller)new CreateApplicationRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CreateApplicationVersionResponse createApplicationVersion(CreateApplicationVersionRequest createApplicationVersionRequest) throws TooManyApplicationsException, TooManyApplicationVersionsException, InsufficientPrivilegesException, S3LocationNotInServiceRegionException, CodeBuildNotInServiceRegionException, AwsServiceException, SdkClientException, ElasticBeanstalkException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateApplicationVersionResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (CreateApplicationVersionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateApplicationVersion").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createApplicationVersionRequest).withMarshaller((Marshaller)new CreateApplicationVersionRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CreateConfigurationTemplateResponse createConfigurationTemplate(CreateConfigurationTemplateRequest createConfigurationTemplateRequest) throws InsufficientPrivilegesException, TooManyBucketsException, TooManyConfigurationTemplatesException, AwsServiceException, SdkClientException, ElasticBeanstalkException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateConfigurationTemplateResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (CreateConfigurationTemplateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateConfigurationTemplate").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createConfigurationTemplateRequest).withMarshaller((Marshaller)new CreateConfigurationTemplateRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CreateEnvironmentResponse createEnvironment(CreateEnvironmentRequest createEnvironmentRequest) throws TooManyEnvironmentsException, InsufficientPrivilegesException, AwsServiceException, SdkClientException, ElasticBeanstalkException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateEnvironmentResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (CreateEnvironmentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateEnvironment").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createEnvironmentRequest).withMarshaller((Marshaller)new CreateEnvironmentRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CreatePlatformVersionResponse createPlatformVersion(CreatePlatformVersionRequest createPlatformVersionRequest) throws InsufficientPrivilegesException, ElasticBeanstalkServiceException, TooManyPlatformsException, AwsServiceException, SdkClientException, ElasticBeanstalkException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreatePlatformVersionResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (CreatePlatformVersionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreatePlatformVersion").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createPlatformVersionRequest).withMarshaller((Marshaller)new CreatePlatformVersionRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CreateStorageLocationResponse createStorageLocation(CreateStorageLocationRequest createStorageLocationRequest) throws TooManyBucketsException, S3SubscriptionRequiredException, InsufficientPrivilegesException, AwsServiceException, SdkClientException, ElasticBeanstalkException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateStorageLocationResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (CreateStorageLocationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateStorageLocation").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createStorageLocationRequest).withMarshaller((Marshaller)new CreateStorageLocationRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteApplicationResponse deleteApplication(DeleteApplicationRequest deleteApplicationRequest) throws OperationInProgressException, AwsServiceException, SdkClientException, ElasticBeanstalkException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteApplicationResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DeleteApplicationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteApplication").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteApplicationRequest).withMarshaller((Marshaller)new DeleteApplicationRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteApplicationVersionResponse deleteApplicationVersion(DeleteApplicationVersionRequest deleteApplicationVersionRequest) throws SourceBundleDeletionException, InsufficientPrivilegesException, OperationInProgressException, S3LocationNotInServiceRegionException, AwsServiceException, SdkClientException, ElasticBeanstalkException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteApplicationVersionResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DeleteApplicationVersionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteApplicationVersion").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteApplicationVersionRequest).withMarshaller((Marshaller)new DeleteApplicationVersionRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteConfigurationTemplateResponse deleteConfigurationTemplate(DeleteConfigurationTemplateRequest deleteConfigurationTemplateRequest) throws OperationInProgressException, AwsServiceException, SdkClientException, ElasticBeanstalkException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteConfigurationTemplateResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DeleteConfigurationTemplateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteConfigurationTemplate").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteConfigurationTemplateRequest).withMarshaller((Marshaller)new DeleteConfigurationTemplateRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteEnvironmentConfigurationResponse deleteEnvironmentConfiguration(DeleteEnvironmentConfigurationRequest deleteEnvironmentConfigurationRequest) throws AwsServiceException, SdkClientException, ElasticBeanstalkException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteEnvironmentConfigurationResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DeleteEnvironmentConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteEnvironmentConfiguration").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteEnvironmentConfigurationRequest).withMarshaller((Marshaller)new DeleteEnvironmentConfigurationRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeletePlatformVersionResponse deletePlatformVersion(DeletePlatformVersionRequest deletePlatformVersionRequest) throws OperationInProgressException, InsufficientPrivilegesException, ElasticBeanstalkServiceException, PlatformVersionStillReferencedException, AwsServiceException, SdkClientException, ElasticBeanstalkException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeletePlatformVersionResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DeletePlatformVersionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeletePlatformVersion").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deletePlatformVersionRequest).withMarshaller((Marshaller)new DeletePlatformVersionRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeAccountAttributesResponse describeAccountAttributes(DescribeAccountAttributesRequest describeAccountAttributesRequest) throws InsufficientPrivilegesException, AwsServiceException, SdkClientException, ElasticBeanstalkException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeAccountAttributesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeAccountAttributesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeAccountAttributes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeAccountAttributesRequest).withMarshaller((Marshaller)new DescribeAccountAttributesRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeApplicationVersionsResponse describeApplicationVersions(DescribeApplicationVersionsRequest describeApplicationVersionsRequest) throws AwsServiceException, SdkClientException, ElasticBeanstalkException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeApplicationVersionsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeApplicationVersionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeApplicationVersions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeApplicationVersionsRequest).withMarshaller((Marshaller)new DescribeApplicationVersionsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeApplicationsResponse describeApplications(DescribeApplicationsRequest describeApplicationsRequest) throws AwsServiceException, SdkClientException, ElasticBeanstalkException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeApplicationsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeApplicationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeApplications").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeApplicationsRequest).withMarshaller((Marshaller)new DescribeApplicationsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeConfigurationOptionsResponse describeConfigurationOptions(DescribeConfigurationOptionsRequest describeConfigurationOptionsRequest) throws TooManyBucketsException, AwsServiceException, SdkClientException, ElasticBeanstalkException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeConfigurationOptionsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeConfigurationOptionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeConfigurationOptions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeConfigurationOptionsRequest).withMarshaller((Marshaller)new DescribeConfigurationOptionsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeConfigurationSettingsResponse describeConfigurationSettings(DescribeConfigurationSettingsRequest describeConfigurationSettingsRequest) throws TooManyBucketsException, AwsServiceException, SdkClientException, ElasticBeanstalkException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeConfigurationSettingsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeConfigurationSettingsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeConfigurationSettings").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeConfigurationSettingsRequest).withMarshaller((Marshaller)new DescribeConfigurationSettingsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeEnvironmentHealthResponse describeEnvironmentHealth(DescribeEnvironmentHealthRequest describeEnvironmentHealthRequest) throws InvalidRequestException, ElasticBeanstalkServiceException, AwsServiceException, SdkClientException, ElasticBeanstalkException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeEnvironmentHealthResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeEnvironmentHealthResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeEnvironmentHealth").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeEnvironmentHealthRequest).withMarshaller((Marshaller)new DescribeEnvironmentHealthRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeEnvironmentManagedActionHistoryResponse describeEnvironmentManagedActionHistory(DescribeEnvironmentManagedActionHistoryRequest describeEnvironmentManagedActionHistoryRequest) throws ElasticBeanstalkServiceException, AwsServiceException, SdkClientException, ElasticBeanstalkException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeEnvironmentManagedActionHistoryResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeEnvironmentManagedActionHistoryResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeEnvironmentManagedActionHistory").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeEnvironmentManagedActionHistoryRequest).withMarshaller((Marshaller)new DescribeEnvironmentManagedActionHistoryRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeEnvironmentManagedActionsResponse describeEnvironmentManagedActions(DescribeEnvironmentManagedActionsRequest describeEnvironmentManagedActionsRequest) throws ElasticBeanstalkServiceException, AwsServiceException, SdkClientException, ElasticBeanstalkException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeEnvironmentManagedActionsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeEnvironmentManagedActionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeEnvironmentManagedActions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeEnvironmentManagedActionsRequest).withMarshaller((Marshaller)new DescribeEnvironmentManagedActionsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeEnvironmentResourcesResponse describeEnvironmentResources(DescribeEnvironmentResourcesRequest describeEnvironmentResourcesRequest) throws InsufficientPrivilegesException, AwsServiceException, SdkClientException, ElasticBeanstalkException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeEnvironmentResourcesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeEnvironmentResourcesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeEnvironmentResources").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeEnvironmentResourcesRequest).withMarshaller((Marshaller)new DescribeEnvironmentResourcesRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeEnvironmentsResponse describeEnvironments(DescribeEnvironmentsRequest describeEnvironmentsRequest) throws AwsServiceException, SdkClientException, ElasticBeanstalkException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeEnvironmentsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeEnvironmentsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeEnvironments").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeEnvironmentsRequest).withMarshaller((Marshaller)new DescribeEnvironmentsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeEventsResponse describeEvents(DescribeEventsRequest describeEventsRequest) throws AwsServiceException, SdkClientException, ElasticBeanstalkException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeEventsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeEventsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeEvents").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeEventsRequest).withMarshaller((Marshaller)new DescribeEventsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeEventsIterable describeEventsPaginator(DescribeEventsRequest describeEventsRequest) throws AwsServiceException, SdkClientException, ElasticBeanstalkException {
        return new DescribeEventsIterable(this, this.applyPaginatorUserAgent(describeEventsRequest));
    }

    @Override
    public DescribeInstancesHealthResponse describeInstancesHealth(DescribeInstancesHealthRequest describeInstancesHealthRequest) throws InvalidRequestException, ElasticBeanstalkServiceException, AwsServiceException, SdkClientException, ElasticBeanstalkException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeInstancesHealthResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeInstancesHealthResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeInstancesHealth").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeInstancesHealthRequest).withMarshaller((Marshaller)new DescribeInstancesHealthRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribePlatformVersionResponse describePlatformVersion(DescribePlatformVersionRequest describePlatformVersionRequest) throws InsufficientPrivilegesException, ElasticBeanstalkServiceException, AwsServiceException, SdkClientException, ElasticBeanstalkException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribePlatformVersionResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribePlatformVersionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribePlatformVersion").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describePlatformVersionRequest).withMarshaller((Marshaller)new DescribePlatformVersionRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListAvailableSolutionStacksResponse listAvailableSolutionStacks(ListAvailableSolutionStacksRequest listAvailableSolutionStacksRequest) throws AwsServiceException, SdkClientException, ElasticBeanstalkException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ListAvailableSolutionStacksResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (ListAvailableSolutionStacksResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListAvailableSolutionStacks").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listAvailableSolutionStacksRequest).withMarshaller((Marshaller)new ListAvailableSolutionStacksRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListPlatformVersionsResponse listPlatformVersions(ListPlatformVersionsRequest listPlatformVersionsRequest) throws InsufficientPrivilegesException, ElasticBeanstalkServiceException, AwsServiceException, SdkClientException, ElasticBeanstalkException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ListPlatformVersionsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (ListPlatformVersionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListPlatformVersions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listPlatformVersionsRequest).withMarshaller((Marshaller)new ListPlatformVersionsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws InsufficientPrivilegesException, ResourceNotFoundException, ResourceTypeNotSupportedException, AwsServiceException, SdkClientException, ElasticBeanstalkException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ListTagsForResourceResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTagsForResourceRequest).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public RebuildEnvironmentResponse rebuildEnvironment(RebuildEnvironmentRequest rebuildEnvironmentRequest) throws InsufficientPrivilegesException, AwsServiceException, SdkClientException, ElasticBeanstalkException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(RebuildEnvironmentResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (RebuildEnvironmentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RebuildEnvironment").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)rebuildEnvironmentRequest).withMarshaller((Marshaller)new RebuildEnvironmentRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public RequestEnvironmentInfoResponse requestEnvironmentInfo(RequestEnvironmentInfoRequest requestEnvironmentInfoRequest) throws AwsServiceException, SdkClientException, ElasticBeanstalkException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(RequestEnvironmentInfoResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (RequestEnvironmentInfoResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RequestEnvironmentInfo").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)requestEnvironmentInfoRequest).withMarshaller((Marshaller)new RequestEnvironmentInfoRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public RestartAppServerResponse restartAppServer(RestartAppServerRequest restartAppServerRequest) throws AwsServiceException, SdkClientException, ElasticBeanstalkException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(RestartAppServerResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (RestartAppServerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RestartAppServer").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)restartAppServerRequest).withMarshaller((Marshaller)new RestartAppServerRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public RetrieveEnvironmentInfoResponse retrieveEnvironmentInfo(RetrieveEnvironmentInfoRequest retrieveEnvironmentInfoRequest) throws AwsServiceException, SdkClientException, ElasticBeanstalkException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(RetrieveEnvironmentInfoResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (RetrieveEnvironmentInfoResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RetrieveEnvironmentInfo").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)retrieveEnvironmentInfoRequest).withMarshaller((Marshaller)new RetrieveEnvironmentInfoRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public SwapEnvironmentCNAMEsResponse swapEnvironmentCNAMEs(SwapEnvironmentCnamEsRequest swapEnvironmentCnamEsRequest) throws AwsServiceException, SdkClientException, ElasticBeanstalkException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(SwapEnvironmentCNAMEsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (SwapEnvironmentCNAMEsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SwapEnvironmentCNAMEs").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)swapEnvironmentCnamEsRequest).withMarshaller((Marshaller)new SwapEnvironmentCnamEsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public TerminateEnvironmentResponse terminateEnvironment(TerminateEnvironmentRequest terminateEnvironmentRequest) throws InsufficientPrivilegesException, AwsServiceException, SdkClientException, ElasticBeanstalkException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(TerminateEnvironmentResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (TerminateEnvironmentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TerminateEnvironment").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)terminateEnvironmentRequest).withMarshaller((Marshaller)new TerminateEnvironmentRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public UpdateApplicationResponse updateApplication(UpdateApplicationRequest updateApplicationRequest) throws AwsServiceException, SdkClientException, ElasticBeanstalkException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(UpdateApplicationResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (UpdateApplicationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateApplication").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateApplicationRequest).withMarshaller((Marshaller)new UpdateApplicationRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public UpdateApplicationResourceLifecycleResponse updateApplicationResourceLifecycle(UpdateApplicationResourceLifecycleRequest updateApplicationResourceLifecycleRequest) throws InsufficientPrivilegesException, AwsServiceException, SdkClientException, ElasticBeanstalkException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(UpdateApplicationResourceLifecycleResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (UpdateApplicationResourceLifecycleResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateApplicationResourceLifecycle").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateApplicationResourceLifecycleRequest).withMarshaller((Marshaller)new UpdateApplicationResourceLifecycleRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public UpdateApplicationVersionResponse updateApplicationVersion(UpdateApplicationVersionRequest updateApplicationVersionRequest) throws AwsServiceException, SdkClientException, ElasticBeanstalkException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(UpdateApplicationVersionResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (UpdateApplicationVersionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateApplicationVersion").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateApplicationVersionRequest).withMarshaller((Marshaller)new UpdateApplicationVersionRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public UpdateConfigurationTemplateResponse updateConfigurationTemplate(UpdateConfigurationTemplateRequest updateConfigurationTemplateRequest) throws InsufficientPrivilegesException, TooManyBucketsException, AwsServiceException, SdkClientException, ElasticBeanstalkException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(UpdateConfigurationTemplateResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (UpdateConfigurationTemplateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateConfigurationTemplate").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateConfigurationTemplateRequest).withMarshaller((Marshaller)new UpdateConfigurationTemplateRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public UpdateEnvironmentResponse updateEnvironment(UpdateEnvironmentRequest updateEnvironmentRequest) throws InsufficientPrivilegesException, TooManyBucketsException, AwsServiceException, SdkClientException, ElasticBeanstalkException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(UpdateEnvironmentResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (UpdateEnvironmentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateEnvironment").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateEnvironmentRequest).withMarshaller((Marshaller)new UpdateEnvironmentRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public UpdateTagsForResourceResponse updateTagsForResource(UpdateTagsForResourceRequest updateTagsForResourceRequest) throws InsufficientPrivilegesException, OperationInProgressException, TooManyTagsException, ResourceNotFoundException, ResourceTypeNotSupportedException, AwsServiceException, SdkClientException, ElasticBeanstalkException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(UpdateTagsForResourceResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (UpdateTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateTagsForResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateTagsForResourceRequest).withMarshaller((Marshaller)new UpdateTagsForResourceRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ValidateConfigurationSettingsResponse validateConfigurationSettings(ValidateConfigurationSettingsRequest validateConfigurationSettingsRequest) throws InsufficientPrivilegesException, TooManyBucketsException, AwsServiceException, SdkClientException, ElasticBeanstalkException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ValidateConfigurationSettingsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (ValidateConfigurationSettingsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ValidateConfigurationSettings").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)validateConfigurationSettingsRequest).withMarshaller((Marshaller)new ValidateConfigurationSettingsRequestMarshaller(this.protocolFactory)));
    }

    private AwsQueryProtocolFactory init() {
        return AwsQueryProtocolFactory.builder().registerModeledException(ExceptionMetadata.builder().errorCode("S3LocationNotInServiceRegionException").exceptionBuilderSupplier(S3LocationNotInServiceRegionException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidRequestException").exceptionBuilderSupplier(InvalidRequestException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ManagedActionInvalidStateException").exceptionBuilderSupplier(ManagedActionInvalidStateException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InsufficientPrivilegesException").exceptionBuilderSupplier(InsufficientPrivilegesException::builder).httpStatusCode(Integer.valueOf(403)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyPlatformsException").exceptionBuilderSupplier(TooManyPlatformsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyApplicationVersionsException").exceptionBuilderSupplier(TooManyApplicationVersionsException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CodeBuildNotInServiceRegionException").exceptionBuilderSupplier(CodeBuildNotInServiceRegionException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("S3SubscriptionRequiredException").exceptionBuilderSupplier(S3SubscriptionRequiredException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SourceBundleDeletionFailure").exceptionBuilderSupplier(SourceBundleDeletionException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyConfigurationTemplatesException").exceptionBuilderSupplier(TooManyConfigurationTemplatesException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceTypeNotSupportedException").exceptionBuilderSupplier(ResourceTypeNotSupportedException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyTagsException").exceptionBuilderSupplier(TooManyTagsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyApplicationsException").exceptionBuilderSupplier(TooManyApplicationsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("OperationInProgressFailure").exceptionBuilderSupplier(OperationInProgressException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyEnvironmentsException").exceptionBuilderSupplier(TooManyEnvironmentsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyBucketsException").exceptionBuilderSupplier(TooManyBucketsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ElasticBeanstalkServiceException").exceptionBuilderSupplier(ElasticBeanstalkServiceException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("PlatformVersionStillReferencedException").exceptionBuilderSupplier(PlatformVersionStillReferencedException::builder).httpStatusCode(Integer.valueOf(400)).build()).clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(ElasticBeanstalkException::builder).build();
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends ElasticBeanstalkRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.9.18").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((ElasticBeanstalkRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }
}

