/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.elasticbeanstalk.model.ActionHistoryStatus;
import software.amazon.awssdk.services.elasticbeanstalk.model.ActionType;
import software.amazon.awssdk.services.elasticbeanstalk.model.FailureType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ManagedActionHistoryItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ManagedActionHistoryItem> {
    private static final SdkField<String> ACTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ManagedActionHistoryItem.getter(ManagedActionHistoryItem::actionId)).setter(ManagedActionHistoryItem.setter(Builder::actionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionId").build()}).build();
    private static final SdkField<String> ACTION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ManagedActionHistoryItem.getter(ManagedActionHistoryItem::actionTypeAsString)).setter(ManagedActionHistoryItem.setter(Builder::actionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionType").build()}).build();
    private static final SdkField<String> ACTION_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ManagedActionHistoryItem.getter(ManagedActionHistoryItem::actionDescription)).setter(ManagedActionHistoryItem.setter(Builder::actionDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionDescription").build()}).build();
    private static final SdkField<String> FAILURE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ManagedActionHistoryItem.getter(ManagedActionHistoryItem::failureTypeAsString)).setter(ManagedActionHistoryItem.setter(Builder::failureType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureType").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ManagedActionHistoryItem.getter(ManagedActionHistoryItem::statusAsString)).setter(ManagedActionHistoryItem.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> FAILURE_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ManagedActionHistoryItem.getter(ManagedActionHistoryItem::failureDescription)).setter(ManagedActionHistoryItem.setter(Builder::failureDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureDescription").build()}).build();
    private static final SdkField<Instant> EXECUTED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(ManagedActionHistoryItem.getter(ManagedActionHistoryItem::executedTime)).setter(ManagedActionHistoryItem.setter(Builder::executedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutedTime").build()}).build();
    private static final SdkField<Instant> FINISHED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(ManagedActionHistoryItem.getter(ManagedActionHistoryItem::finishedTime)).setter(ManagedActionHistoryItem.setter(Builder::finishedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FinishedTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_ID_FIELD, ACTION_TYPE_FIELD, ACTION_DESCRIPTION_FIELD, FAILURE_TYPE_FIELD, STATUS_FIELD, FAILURE_DESCRIPTION_FIELD, EXECUTED_TIME_FIELD, FINISHED_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String actionId;
    private final String actionType;
    private final String actionDescription;
    private final String failureType;
    private final String status;
    private final String failureDescription;
    private final Instant executedTime;
    private final Instant finishedTime;

    private ManagedActionHistoryItem(BuilderImpl builder) {
        this.actionId = builder.actionId;
        this.actionType = builder.actionType;
        this.actionDescription = builder.actionDescription;
        this.failureType = builder.failureType;
        this.status = builder.status;
        this.failureDescription = builder.failureDescription;
        this.executedTime = builder.executedTime;
        this.finishedTime = builder.finishedTime;
    }

    public String actionId() {
        return this.actionId;
    }

    public ActionType actionType() {
        return ActionType.fromValue(this.actionType);
    }

    public String actionTypeAsString() {
        return this.actionType;
    }

    public String actionDescription() {
        return this.actionDescription;
    }

    public FailureType failureType() {
        return FailureType.fromValue(this.failureType);
    }

    public String failureTypeAsString() {
        return this.failureType;
    }

    public ActionHistoryStatus status() {
        return ActionHistoryStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public String failureDescription() {
        return this.failureDescription;
    }

    public Instant executedTime() {
        return this.executedTime;
    }

    public Instant finishedTime() {
        return this.finishedTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.actionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.executedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.finishedTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ManagedActionHistoryItem)) {
            return false;
        }
        ManagedActionHistoryItem other = (ManagedActionHistoryItem)obj;
        return Objects.equals(this.actionId(), other.actionId()) && Objects.equals(this.actionTypeAsString(), other.actionTypeAsString()) && Objects.equals(this.actionDescription(), other.actionDescription()) && Objects.equals(this.failureTypeAsString(), other.failureTypeAsString()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.failureDescription(), other.failureDescription()) && Objects.equals(this.executedTime(), other.executedTime()) && Objects.equals(this.finishedTime(), other.finishedTime());
    }

    public String toString() {
        return ToString.builder((String)"ManagedActionHistoryItem").add("ActionId", (Object)this.actionId()).add("ActionType", (Object)this.actionTypeAsString()).add("ActionDescription", (Object)this.actionDescription()).add("FailureType", (Object)this.failureTypeAsString()).add("Status", (Object)this.statusAsString()).add("FailureDescription", (Object)this.failureDescription()).add("ExecutedTime", (Object)this.executedTime()).add("FinishedTime", (Object)this.finishedTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ActionId": {
                return Optional.ofNullable(clazz.cast(this.actionId()));
            }
            case "ActionType": {
                return Optional.ofNullable(clazz.cast(this.actionTypeAsString()));
            }
            case "ActionDescription": {
                return Optional.ofNullable(clazz.cast(this.actionDescription()));
            }
            case "FailureType": {
                return Optional.ofNullable(clazz.cast(this.failureTypeAsString()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "FailureDescription": {
                return Optional.ofNullable(clazz.cast(this.failureDescription()));
            }
            case "ExecutedTime": {
                return Optional.ofNullable(clazz.cast(this.executedTime()));
            }
            case "FinishedTime": {
                return Optional.ofNullable(clazz.cast(this.finishedTime()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ManagedActionHistoryItem, T> g) {
        return obj -> g.apply((ManagedActionHistoryItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String actionId;
        private String actionType;
        private String actionDescription;
        private String failureType;
        private String status;
        private String failureDescription;
        private Instant executedTime;
        private Instant finishedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ManagedActionHistoryItem model) {
            this.actionId(model.actionId);
            this.actionType(model.actionType);
            this.actionDescription(model.actionDescription);
            this.failureType(model.failureType);
            this.status(model.status);
            this.failureDescription(model.failureDescription);
            this.executedTime(model.executedTime);
            this.finishedTime(model.finishedTime);
        }

        public final String getActionId() {
            return this.actionId;
        }

        @Override
        public final Builder actionId(String actionId) {
            this.actionId = actionId;
            return this;
        }

        public final void setActionId(String actionId) {
            this.actionId = actionId;
        }

        public final String getActionTypeAsString() {
            return this.actionType;
        }

        @Override
        public final Builder actionType(String actionType) {
            this.actionType = actionType;
            return this;
        }

        @Override
        public final Builder actionType(ActionType actionType) {
            this.actionType(actionType.toString());
            return this;
        }

        public final void setActionType(String actionType) {
            this.actionType = actionType;
        }

        public final String getActionDescription() {
            return this.actionDescription;
        }

        @Override
        public final Builder actionDescription(String actionDescription) {
            this.actionDescription = actionDescription;
            return this;
        }

        public final void setActionDescription(String actionDescription) {
            this.actionDescription = actionDescription;
        }

        public final String getFailureTypeAsString() {
            return this.failureType;
        }

        @Override
        public final Builder failureType(String failureType) {
            this.failureType = failureType;
            return this;
        }

        @Override
        public final Builder failureType(FailureType failureType) {
            this.failureType(failureType.toString());
            return this;
        }

        public final void setFailureType(String failureType) {
            this.failureType = failureType;
        }

        public final String getStatusAsString() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ActionHistoryStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getFailureDescription() {
            return this.failureDescription;
        }

        @Override
        public final Builder failureDescription(String failureDescription) {
            this.failureDescription = failureDescription;
            return this;
        }

        public final void setFailureDescription(String failureDescription) {
            this.failureDescription = failureDescription;
        }

        public final Instant getExecutedTime() {
            return this.executedTime;
        }

        @Override
        public final Builder executedTime(Instant executedTime) {
            this.executedTime = executedTime;
            return this;
        }

        public final void setExecutedTime(Instant executedTime) {
            this.executedTime = executedTime;
        }

        public final Instant getFinishedTime() {
            return this.finishedTime;
        }

        @Override
        public final Builder finishedTime(Instant finishedTime) {
            this.finishedTime = finishedTime;
            return this;
        }

        public final void setFinishedTime(Instant finishedTime) {
            this.finishedTime = finishedTime;
        }

        public ManagedActionHistoryItem build() {
            return new ManagedActionHistoryItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ManagedActionHistoryItem> {
        public Builder actionId(String var1);

        public Builder actionType(String var1);

        public Builder actionType(ActionType var1);

        public Builder actionDescription(String var1);

        public Builder failureType(String var1);

        public Builder failureType(FailureType var1);

        public Builder status(String var1);

        public Builder status(ActionHistoryStatus var1);

        public Builder failureDescription(String var1);

        public Builder executedTime(Instant var1);

        public Builder finishedTime(Instant var1);
    }
}

