/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.elasticbeanstalk.model.CPUUtilization;
import software.amazon.awssdk.services.elasticbeanstalk.model.LoadAverageCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SystemStatus
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SystemStatus> {
    private static final SdkField<CPUUtilization> CPU_UTILIZATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(SystemStatus.getter(SystemStatus::cpuUtilization)).setter(SystemStatus.setter(Builder::cpuUtilization)).constructor(CPUUtilization::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CPUUtilization").build()}).build();
    private static final SdkField<List<Double>> LOAD_AVERAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(SystemStatus.getter(SystemStatus::loadAverage)).setter(SystemStatus.setter(Builder::loadAverage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoadAverage").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.DOUBLE).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CPU_UTILIZATION_FIELD, LOAD_AVERAGE_FIELD));
    private static final long serialVersionUID = 1L;
    private final CPUUtilization cpuUtilization;
    private final List<Double> loadAverage;

    private SystemStatus(BuilderImpl builder) {
        this.cpuUtilization = builder.cpuUtilization;
        this.loadAverage = builder.loadAverage;
    }

    public CPUUtilization cpuUtilization() {
        return this.cpuUtilization;
    }

    public List<Double> loadAverage() {
        return this.loadAverage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.cpuUtilization());
        hashCode = 31 * hashCode + Objects.hashCode(this.loadAverage());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SystemStatus)) {
            return false;
        }
        SystemStatus other = (SystemStatus)obj;
        return Objects.equals(this.cpuUtilization(), other.cpuUtilization()) && Objects.equals(this.loadAverage(), other.loadAverage());
    }

    public String toString() {
        return ToString.builder((String)"SystemStatus").add("CPUUtilization", (Object)this.cpuUtilization()).add("LoadAverage", this.loadAverage()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CPUUtilization": {
                return Optional.ofNullable(clazz.cast(this.cpuUtilization()));
            }
            case "LoadAverage": {
                return Optional.ofNullable(clazz.cast(this.loadAverage()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SystemStatus, T> g) {
        return obj -> g.apply((SystemStatus)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private CPUUtilization cpuUtilization;
        private List<Double> loadAverage = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SystemStatus model) {
            this.cpuUtilization(model.cpuUtilization);
            this.loadAverage(model.loadAverage);
        }

        public final CPUUtilization.Builder getCpuUtilization() {
            return this.cpuUtilization != null ? this.cpuUtilization.toBuilder() : null;
        }

        @Override
        public final Builder cpuUtilization(CPUUtilization cpuUtilization) {
            this.cpuUtilization = cpuUtilization;
            return this;
        }

        public final void setCpuUtilization(CPUUtilization.BuilderImpl cpuUtilization) {
            this.cpuUtilization = cpuUtilization != null ? cpuUtilization.build() : null;
        }

        public final Collection<Double> getLoadAverage() {
            return this.loadAverage;
        }

        @Override
        public final Builder loadAverage(Collection<Double> loadAverage) {
            this.loadAverage = LoadAverageCopier.copy(loadAverage);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loadAverage(Double ... loadAverage) {
            this.loadAverage(Arrays.asList(loadAverage));
            return this;
        }

        public final void setLoadAverage(Collection<Double> loadAverage) {
            this.loadAverage = LoadAverageCopier.copy(loadAverage);
        }

        public SystemStatus build() {
            return new SystemStatus(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SystemStatus> {
        public Builder cpuUtilization(CPUUtilization var1);

        default public Builder cpuUtilization(Consumer<CPUUtilization.Builder> cpuUtilization) {
            return this.cpuUtilization((CPUUtilization)((CPUUtilization.Builder)CPUUtilization.builder().applyMutation(cpuUtilization)).build());
        }

        public Builder loadAverage(Collection<Double> var1);

        public Builder loadAverage(Double ... var1);
    }
}

