/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.elasticbeanstalk.model.ApplicationVersionDescription;
import software.amazon.awssdk.services.elasticbeanstalk.model.ElasticBeanstalkResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateApplicationVersionResponse
extends ElasticBeanstalkResponse
implements ToCopyableBuilder<Builder, UpdateApplicationVersionResponse> {
    private static final SdkField<ApplicationVersionDescription> APPLICATION_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(UpdateApplicationVersionResponse.getter(UpdateApplicationVersionResponse::applicationVersion)).setter(UpdateApplicationVersionResponse.setter(Builder::applicationVersion)).constructor(ApplicationVersionDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_VERSION_FIELD));
    private final ApplicationVersionDescription applicationVersion;

    private UpdateApplicationVersionResponse(BuilderImpl builder) {
        super(builder);
        this.applicationVersion = builder.applicationVersion;
    }

    public ApplicationVersionDescription applicationVersion() {
        return this.applicationVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationVersion());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateApplicationVersionResponse)) {
            return false;
        }
        UpdateApplicationVersionResponse other = (UpdateApplicationVersionResponse)((Object)obj);
        return Objects.equals(this.applicationVersion(), other.applicationVersion());
    }

    public String toString() {
        return ToString.builder((String)"UpdateApplicationVersionResponse").add("ApplicationVersion", (Object)this.applicationVersion()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationVersion": {
                return Optional.ofNullable(clazz.cast(this.applicationVersion()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateApplicationVersionResponse, T> g) {
        return obj -> g.apply((UpdateApplicationVersionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElasticBeanstalkResponse.BuilderImpl
    implements Builder {
        private ApplicationVersionDescription applicationVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateApplicationVersionResponse model) {
            super(model);
            this.applicationVersion(model.applicationVersion);
        }

        public final ApplicationVersionDescription.Builder getApplicationVersion() {
            return this.applicationVersion != null ? this.applicationVersion.toBuilder() : null;
        }

        @Override
        public final Builder applicationVersion(ApplicationVersionDescription applicationVersion) {
            this.applicationVersion = applicationVersion;
            return this;
        }

        public final void setApplicationVersion(ApplicationVersionDescription.BuilderImpl applicationVersion) {
            this.applicationVersion = applicationVersion != null ? applicationVersion.build() : null;
        }

        @Override
        public UpdateApplicationVersionResponse build() {
            return new UpdateApplicationVersionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ElasticBeanstalkResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateApplicationVersionResponse> {
        public Builder applicationVersion(ApplicationVersionDescription var1);

        default public Builder applicationVersion(Consumer<ApplicationVersionDescription.Builder> applicationVersion) {
            return this.applicationVersion((ApplicationVersionDescription)((ApplicationVersionDescription.Builder)ApplicationVersionDescription.builder().applyMutation(applicationVersion)).build());
        }
    }
}

