/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticbeanstalk.model.ApplicationMetrics;
import software.amazon.awssdk.services.elasticbeanstalk.model.CausesCopier;
import software.amazon.awssdk.services.elasticbeanstalk.model.ElasticBeanstalkResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentHealth;
import software.amazon.awssdk.services.elasticbeanstalk.model.InstanceHealthSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeEnvironmentHealthResponse
extends ElasticBeanstalkResponse
implements ToCopyableBuilder<Builder, DescribeEnvironmentHealthResponse> {
    private static final SdkField<String> ENVIRONMENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EnvironmentName").getter(DescribeEnvironmentHealthResponse.getter(DescribeEnvironmentHealthResponse::environmentName)).setter(DescribeEnvironmentHealthResponse.setter(Builder::environmentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnvironmentName").build()}).build();
    private static final SdkField<String> HEALTH_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HealthStatus").getter(DescribeEnvironmentHealthResponse.getter(DescribeEnvironmentHealthResponse::healthStatus)).setter(DescribeEnvironmentHealthResponse.setter(Builder::healthStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthStatus").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(DescribeEnvironmentHealthResponse.getter(DescribeEnvironmentHealthResponse::statusAsString)).setter(DescribeEnvironmentHealthResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> COLOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Color").getter(DescribeEnvironmentHealthResponse.getter(DescribeEnvironmentHealthResponse::color)).setter(DescribeEnvironmentHealthResponse.setter(Builder::color)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Color").build()}).build();
    private static final SdkField<List<String>> CAUSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Causes").getter(DescribeEnvironmentHealthResponse.getter(DescribeEnvironmentHealthResponse::causes)).setter(DescribeEnvironmentHealthResponse.setter(Builder::causes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Causes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ApplicationMetrics> APPLICATION_METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ApplicationMetrics").getter(DescribeEnvironmentHealthResponse.getter(DescribeEnvironmentHealthResponse::applicationMetrics)).setter(DescribeEnvironmentHealthResponse.setter(Builder::applicationMetrics)).constructor(ApplicationMetrics::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationMetrics").build()}).build();
    private static final SdkField<InstanceHealthSummary> INSTANCES_HEALTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InstancesHealth").getter(DescribeEnvironmentHealthResponse.getter(DescribeEnvironmentHealthResponse::instancesHealth)).setter(DescribeEnvironmentHealthResponse.setter(Builder::instancesHealth)).constructor(InstanceHealthSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstancesHealth").build()}).build();
    private static final SdkField<Instant> REFRESHED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("RefreshedAt").getter(DescribeEnvironmentHealthResponse.getter(DescribeEnvironmentHealthResponse::refreshedAt)).setter(DescribeEnvironmentHealthResponse.setter(Builder::refreshedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RefreshedAt").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENVIRONMENT_NAME_FIELD, HEALTH_STATUS_FIELD, STATUS_FIELD, COLOR_FIELD, CAUSES_FIELD, APPLICATION_METRICS_FIELD, INSTANCES_HEALTH_FIELD, REFRESHED_AT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeEnvironmentHealthResponse.memberNameToFieldInitializer();
    private final String environmentName;
    private final String healthStatus;
    private final String status;
    private final String color;
    private final List<String> causes;
    private final ApplicationMetrics applicationMetrics;
    private final InstanceHealthSummary instancesHealth;
    private final Instant refreshedAt;

    private DescribeEnvironmentHealthResponse(BuilderImpl builder) {
        super(builder);
        this.environmentName = builder.environmentName;
        this.healthStatus = builder.healthStatus;
        this.status = builder.status;
        this.color = builder.color;
        this.causes = builder.causes;
        this.applicationMetrics = builder.applicationMetrics;
        this.instancesHealth = builder.instancesHealth;
        this.refreshedAt = builder.refreshedAt;
    }

    public final String environmentName() {
        return this.environmentName;
    }

    public final String healthStatus() {
        return this.healthStatus;
    }

    public final EnvironmentHealth status() {
        return EnvironmentHealth.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String color() {
        return this.color;
    }

    public final boolean hasCauses() {
        return this.causes != null && !(this.causes instanceof SdkAutoConstructList);
    }

    public final List<String> causes() {
        return this.causes;
    }

    public final ApplicationMetrics applicationMetrics() {
        return this.applicationMetrics;
    }

    public final InstanceHealthSummary instancesHealth() {
        return this.instancesHealth;
    }

    public final Instant refreshedAt() {
        return this.refreshedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.healthStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.color());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCauses() ? this.causes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationMetrics());
        hashCode = 31 * hashCode + Objects.hashCode(this.instancesHealth());
        hashCode = 31 * hashCode + Objects.hashCode(this.refreshedAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEnvironmentHealthResponse)) {
            return false;
        }
        DescribeEnvironmentHealthResponse other = (DescribeEnvironmentHealthResponse)((Object)obj);
        return Objects.equals(this.environmentName(), other.environmentName()) && Objects.equals(this.healthStatus(), other.healthStatus()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.color(), other.color()) && this.hasCauses() == other.hasCauses() && Objects.equals(this.causes(), other.causes()) && Objects.equals(this.applicationMetrics(), other.applicationMetrics()) && Objects.equals(this.instancesHealth(), other.instancesHealth()) && Objects.equals(this.refreshedAt(), other.refreshedAt());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeEnvironmentHealthResponse").add("EnvironmentName", (Object)this.environmentName()).add("HealthStatus", (Object)this.healthStatus()).add("Status", (Object)this.statusAsString()).add("Color", (Object)this.color()).add("Causes", this.hasCauses() ? this.causes() : null).add("ApplicationMetrics", (Object)this.applicationMetrics()).add("InstancesHealth", (Object)this.instancesHealth()).add("RefreshedAt", (Object)this.refreshedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EnvironmentName": {
                return Optional.ofNullable(clazz.cast(this.environmentName()));
            }
            case "HealthStatus": {
                return Optional.ofNullable(clazz.cast(this.healthStatus()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "Color": {
                return Optional.ofNullable(clazz.cast(this.color()));
            }
            case "Causes": {
                return Optional.ofNullable(clazz.cast(this.causes()));
            }
            case "ApplicationMetrics": {
                return Optional.ofNullable(clazz.cast(this.applicationMetrics()));
            }
            case "InstancesHealth": {
                return Optional.ofNullable(clazz.cast(this.instancesHealth()));
            }
            case "RefreshedAt": {
                return Optional.ofNullable(clazz.cast(this.refreshedAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("EnvironmentName", ENVIRONMENT_NAME_FIELD);
        map.put("HealthStatus", HEALTH_STATUS_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("Color", COLOR_FIELD);
        map.put("Causes", CAUSES_FIELD);
        map.put("ApplicationMetrics", APPLICATION_METRICS_FIELD);
        map.put("InstancesHealth", INSTANCES_HEALTH_FIELD);
        map.put("RefreshedAt", REFRESHED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeEnvironmentHealthResponse, T> g) {
        return obj -> g.apply((DescribeEnvironmentHealthResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElasticBeanstalkResponse.BuilderImpl
    implements Builder {
        private String environmentName;
        private String healthStatus;
        private String status;
        private String color;
        private List<String> causes = DefaultSdkAutoConstructList.getInstance();
        private ApplicationMetrics applicationMetrics;
        private InstanceHealthSummary instancesHealth;
        private Instant refreshedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEnvironmentHealthResponse model) {
            super(model);
            this.environmentName(model.environmentName);
            this.healthStatus(model.healthStatus);
            this.status(model.status);
            this.color(model.color);
            this.causes(model.causes);
            this.applicationMetrics(model.applicationMetrics);
            this.instancesHealth(model.instancesHealth);
            this.refreshedAt(model.refreshedAt);
        }

        public final String getEnvironmentName() {
            return this.environmentName;
        }

        public final void setEnvironmentName(String environmentName) {
            this.environmentName = environmentName;
        }

        @Override
        public final Builder environmentName(String environmentName) {
            this.environmentName = environmentName;
            return this;
        }

        public final String getHealthStatus() {
            return this.healthStatus;
        }

        public final void setHealthStatus(String healthStatus) {
            this.healthStatus = healthStatus;
        }

        @Override
        public final Builder healthStatus(String healthStatus) {
            this.healthStatus = healthStatus;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(EnvironmentHealth status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getColor() {
            return this.color;
        }

        public final void setColor(String color) {
            this.color = color;
        }

        @Override
        public final Builder color(String color) {
            this.color = color;
            return this;
        }

        public final Collection<String> getCauses() {
            if (this.causes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.causes;
        }

        public final void setCauses(Collection<String> causes) {
            this.causes = CausesCopier.copy(causes);
        }

        @Override
        public final Builder causes(Collection<String> causes) {
            this.causes = CausesCopier.copy(causes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder causes(String ... causes) {
            this.causes(Arrays.asList(causes));
            return this;
        }

        public final ApplicationMetrics.Builder getApplicationMetrics() {
            return this.applicationMetrics != null ? this.applicationMetrics.toBuilder() : null;
        }

        public final void setApplicationMetrics(ApplicationMetrics.BuilderImpl applicationMetrics) {
            this.applicationMetrics = applicationMetrics != null ? applicationMetrics.build() : null;
        }

        @Override
        public final Builder applicationMetrics(ApplicationMetrics applicationMetrics) {
            this.applicationMetrics = applicationMetrics;
            return this;
        }

        public final InstanceHealthSummary.Builder getInstancesHealth() {
            return this.instancesHealth != null ? this.instancesHealth.toBuilder() : null;
        }

        public final void setInstancesHealth(InstanceHealthSummary.BuilderImpl instancesHealth) {
            this.instancesHealth = instancesHealth != null ? instancesHealth.build() : null;
        }

        @Override
        public final Builder instancesHealth(InstanceHealthSummary instancesHealth) {
            this.instancesHealth = instancesHealth;
            return this;
        }

        public final Instant getRefreshedAt() {
            return this.refreshedAt;
        }

        public final void setRefreshedAt(Instant refreshedAt) {
            this.refreshedAt = refreshedAt;
        }

        @Override
        public final Builder refreshedAt(Instant refreshedAt) {
            this.refreshedAt = refreshedAt;
            return this;
        }

        @Override
        public DescribeEnvironmentHealthResponse build() {
            return new DescribeEnvironmentHealthResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ElasticBeanstalkResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeEnvironmentHealthResponse> {
        public Builder environmentName(String var1);

        public Builder healthStatus(String var1);

        public Builder status(String var1);

        public Builder status(EnvironmentHealth var1);

        public Builder color(String var1);

        public Builder causes(Collection<String> var1);

        public Builder causes(String ... var1);

        public Builder applicationMetrics(ApplicationMetrics var1);

        default public Builder applicationMetrics(Consumer<ApplicationMetrics.Builder> applicationMetrics) {
            return this.applicationMetrics((ApplicationMetrics)((ApplicationMetrics.Builder)ApplicationMetrics.builder().applyMutation(applicationMetrics)).build());
        }

        public Builder instancesHealth(InstanceHealthSummary var1);

        default public Builder instancesHealth(Consumer<InstanceHealthSummary.Builder> instancesHealth) {
            return this.instancesHealth((InstanceHealthSummary)((InstanceHealthSummary.Builder)InstanceHealthSummary.builder().applyMutation(instancesHealth)).build());
        }

        public Builder refreshedAt(Instant var1);
    }
}

