/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.elasticbeanstalk.ElasticBeanstalkClient;
import software.amazon.awssdk.services.elasticbeanstalk.internal.UserAgentUtils;
import software.amazon.awssdk.services.elasticbeanstalk.model.ListPlatformBranchesRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.ListPlatformBranchesResponse;

public class ListPlatformBranchesIterable
implements SdkIterable<ListPlatformBranchesResponse> {
    private final ElasticBeanstalkClient client;
    private final ListPlatformBranchesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListPlatformBranchesIterable(ElasticBeanstalkClient client, ListPlatformBranchesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListPlatformBranchesResponseFetcher();
    }

    public Iterator<ListPlatformBranchesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListPlatformBranchesResponseFetcher
    implements SyncPageFetcher<ListPlatformBranchesResponse> {
        private ListPlatformBranchesResponseFetcher() {
        }

        public boolean hasNextPage(ListPlatformBranchesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListPlatformBranchesResponse nextPage(ListPlatformBranchesResponse previousPage) {
            if (previousPage == null) {
                return ListPlatformBranchesIterable.this.client.listPlatformBranches(ListPlatformBranchesIterable.this.firstRequest);
            }
            return ListPlatformBranchesIterable.this.client.listPlatformBranches((ListPlatformBranchesRequest)((Object)ListPlatformBranchesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

