/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.elasticbeanstalk.model.ElasticBeanstalkRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.OptionSpecification;
import software.amazon.awssdk.services.elasticbeanstalk.model.OptionsSpecifierListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeConfigurationOptionsRequest
extends ElasticBeanstalkRequest
implements ToCopyableBuilder<Builder, DescribeConfigurationOptionsRequest> {
    private static final SdkField<String> APPLICATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeConfigurationOptionsRequest.getter(DescribeConfigurationOptionsRequest::applicationName)).setter(DescribeConfigurationOptionsRequest.setter(Builder::applicationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationName").build()}).build();
    private static final SdkField<String> TEMPLATE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeConfigurationOptionsRequest.getter(DescribeConfigurationOptionsRequest::templateName)).setter(DescribeConfigurationOptionsRequest.setter(Builder::templateName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateName").build()}).build();
    private static final SdkField<String> ENVIRONMENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeConfigurationOptionsRequest.getter(DescribeConfigurationOptionsRequest::environmentName)).setter(DescribeConfigurationOptionsRequest.setter(Builder::environmentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnvironmentName").build()}).build();
    private static final SdkField<String> SOLUTION_STACK_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeConfigurationOptionsRequest.getter(DescribeConfigurationOptionsRequest::solutionStackName)).setter(DescribeConfigurationOptionsRequest.setter(Builder::solutionStackName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SolutionStackName").build()}).build();
    private static final SdkField<String> PLATFORM_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeConfigurationOptionsRequest.getter(DescribeConfigurationOptionsRequest::platformArn)).setter(DescribeConfigurationOptionsRequest.setter(Builder::platformArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlatformArn").build()}).build();
    private static final SdkField<List<OptionSpecification>> OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeConfigurationOptionsRequest.getter(DescribeConfigurationOptionsRequest::options)).setter(DescribeConfigurationOptionsRequest.setter(Builder::options)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Options").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OptionSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_NAME_FIELD, TEMPLATE_NAME_FIELD, ENVIRONMENT_NAME_FIELD, SOLUTION_STACK_NAME_FIELD, PLATFORM_ARN_FIELD, OPTIONS_FIELD));
    private final String applicationName;
    private final String templateName;
    private final String environmentName;
    private final String solutionStackName;
    private final String platformArn;
    private final List<OptionSpecification> options;

    private DescribeConfigurationOptionsRequest(BuilderImpl builder) {
        super(builder);
        this.applicationName = builder.applicationName;
        this.templateName = builder.templateName;
        this.environmentName = builder.environmentName;
        this.solutionStackName = builder.solutionStackName;
        this.platformArn = builder.platformArn;
        this.options = builder.options;
    }

    public String applicationName() {
        return this.applicationName;
    }

    public String templateName() {
        return this.templateName;
    }

    public String environmentName() {
        return this.environmentName;
    }

    public String solutionStackName() {
        return this.solutionStackName;
    }

    public String platformArn() {
        return this.platformArn;
    }

    public List<OptionSpecification> options() {
        return this.options;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateName());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.solutionStackName());
        hashCode = 31 * hashCode + Objects.hashCode(this.platformArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.options());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeConfigurationOptionsRequest)) {
            return false;
        }
        DescribeConfigurationOptionsRequest other = (DescribeConfigurationOptionsRequest)((Object)obj);
        return Objects.equals(this.applicationName(), other.applicationName()) && Objects.equals(this.templateName(), other.templateName()) && Objects.equals(this.environmentName(), other.environmentName()) && Objects.equals(this.solutionStackName(), other.solutionStackName()) && Objects.equals(this.platformArn(), other.platformArn()) && Objects.equals(this.options(), other.options());
    }

    public String toString() {
        return ToString.builder((String)"DescribeConfigurationOptionsRequest").add("ApplicationName", (Object)this.applicationName()).add("TemplateName", (Object)this.templateName()).add("EnvironmentName", (Object)this.environmentName()).add("SolutionStackName", (Object)this.solutionStackName()).add("PlatformArn", (Object)this.platformArn()).add("Options", this.options()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationName": {
                return Optional.ofNullable(clazz.cast(this.applicationName()));
            }
            case "TemplateName": {
                return Optional.ofNullable(clazz.cast(this.templateName()));
            }
            case "EnvironmentName": {
                return Optional.ofNullable(clazz.cast(this.environmentName()));
            }
            case "SolutionStackName": {
                return Optional.ofNullable(clazz.cast(this.solutionStackName()));
            }
            case "PlatformArn": {
                return Optional.ofNullable(clazz.cast(this.platformArn()));
            }
            case "Options": {
                return Optional.ofNullable(clazz.cast(this.options()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeConfigurationOptionsRequest, T> g) {
        return obj -> g.apply((DescribeConfigurationOptionsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElasticBeanstalkRequest.BuilderImpl
    implements Builder {
        private String applicationName;
        private String templateName;
        private String environmentName;
        private String solutionStackName;
        private String platformArn;
        private List<OptionSpecification> options = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeConfigurationOptionsRequest model) {
            super(model);
            this.applicationName(model.applicationName);
            this.templateName(model.templateName);
            this.environmentName(model.environmentName);
            this.solutionStackName(model.solutionStackName);
            this.platformArn(model.platformArn);
            this.options(model.options);
        }

        public final String getApplicationName() {
            return this.applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final String getTemplateName() {
            return this.templateName;
        }

        @Override
        public final Builder templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        public final void setTemplateName(String templateName) {
            this.templateName = templateName;
        }

        public final String getEnvironmentName() {
            return this.environmentName;
        }

        @Override
        public final Builder environmentName(String environmentName) {
            this.environmentName = environmentName;
            return this;
        }

        public final void setEnvironmentName(String environmentName) {
            this.environmentName = environmentName;
        }

        public final String getSolutionStackName() {
            return this.solutionStackName;
        }

        @Override
        public final Builder solutionStackName(String solutionStackName) {
            this.solutionStackName = solutionStackName;
            return this;
        }

        public final void setSolutionStackName(String solutionStackName) {
            this.solutionStackName = solutionStackName;
        }

        public final String getPlatformArn() {
            return this.platformArn;
        }

        @Override
        public final Builder platformArn(String platformArn) {
            this.platformArn = platformArn;
            return this;
        }

        public final void setPlatformArn(String platformArn) {
            this.platformArn = platformArn;
        }

        public final Collection<OptionSpecification.Builder> getOptions() {
            return this.options != null ? (Collection)this.options.stream().map(OptionSpecification::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder options(Collection<OptionSpecification> options) {
            this.options = OptionsSpecifierListCopier.copy(options);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder options(OptionSpecification ... options) {
            this.options(Arrays.asList(options));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder options(Consumer<OptionSpecification.Builder> ... options) {
            this.options(Stream.of(options).map(c -> (OptionSpecification)((OptionSpecification.Builder)OptionSpecification.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setOptions(Collection<OptionSpecification.BuilderImpl> options) {
            this.options = OptionsSpecifierListCopier.copyFromBuilder(options);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeConfigurationOptionsRequest build() {
            return new DescribeConfigurationOptionsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ElasticBeanstalkRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeConfigurationOptionsRequest> {
        public Builder applicationName(String var1);

        public Builder templateName(String var1);

        public Builder environmentName(String var1);

        public Builder solutionStackName(String var1);

        public Builder platformArn(String var1);

        public Builder options(Collection<OptionSpecification> var1);

        public Builder options(OptionSpecification ... var1);

        public Builder options(Consumer<OptionSpecification.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

