/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.elasticbeanstalk.model.SourceRepository;
import software.amazon.awssdk.services.elasticbeanstalk.model.SourceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SourceBuildInformation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SourceBuildInformation> {
    private static final SdkField<String> SOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SourceBuildInformation.getter(SourceBuildInformation::sourceTypeAsString)).setter(SourceBuildInformation.setter(Builder::sourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceType").build()}).build();
    private static final SdkField<String> SOURCE_REPOSITORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SourceBuildInformation.getter(SourceBuildInformation::sourceRepositoryAsString)).setter(SourceBuildInformation.setter(Builder::sourceRepository)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceRepository").build()}).build();
    private static final SdkField<String> SOURCE_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SourceBuildInformation.getter(SourceBuildInformation::sourceLocation)).setter(SourceBuildInformation.setter(Builder::sourceLocation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceLocation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_TYPE_FIELD, SOURCE_REPOSITORY_FIELD, SOURCE_LOCATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String sourceType;
    private final String sourceRepository;
    private final String sourceLocation;

    private SourceBuildInformation(BuilderImpl builder) {
        this.sourceType = builder.sourceType;
        this.sourceRepository = builder.sourceRepository;
        this.sourceLocation = builder.sourceLocation;
    }

    public SourceType sourceType() {
        return SourceType.fromValue(this.sourceType);
    }

    public String sourceTypeAsString() {
        return this.sourceType;
    }

    public SourceRepository sourceRepository() {
        return SourceRepository.fromValue(this.sourceRepository);
    }

    public String sourceRepositoryAsString() {
        return this.sourceRepository;
    }

    public String sourceLocation() {
        return this.sourceLocation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceRepositoryAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceLocation());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SourceBuildInformation)) {
            return false;
        }
        SourceBuildInformation other = (SourceBuildInformation)obj;
        return Objects.equals(this.sourceTypeAsString(), other.sourceTypeAsString()) && Objects.equals(this.sourceRepositoryAsString(), other.sourceRepositoryAsString()) && Objects.equals(this.sourceLocation(), other.sourceLocation());
    }

    public String toString() {
        return ToString.builder((String)"SourceBuildInformation").add("SourceType", (Object)this.sourceTypeAsString()).add("SourceRepository", (Object)this.sourceRepositoryAsString()).add("SourceLocation", (Object)this.sourceLocation()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SourceType": {
                return Optional.ofNullable(clazz.cast(this.sourceTypeAsString()));
            }
            case "SourceRepository": {
                return Optional.ofNullable(clazz.cast(this.sourceRepositoryAsString()));
            }
            case "SourceLocation": {
                return Optional.ofNullable(clazz.cast(this.sourceLocation()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SourceBuildInformation, T> g) {
        return obj -> g.apply((SourceBuildInformation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String sourceType;
        private String sourceRepository;
        private String sourceLocation;

        private BuilderImpl() {
        }

        private BuilderImpl(SourceBuildInformation model) {
            this.sourceType(model.sourceType);
            this.sourceRepository(model.sourceRepository);
            this.sourceLocation(model.sourceLocation);
        }

        public final String getSourceTypeAsString() {
            return this.sourceType;
        }

        @Override
        public final Builder sourceType(String sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        @Override
        public final Builder sourceType(SourceType sourceType) {
            this.sourceType(sourceType.toString());
            return this;
        }

        public final void setSourceType(String sourceType) {
            this.sourceType = sourceType;
        }

        public final String getSourceRepositoryAsString() {
            return this.sourceRepository;
        }

        @Override
        public final Builder sourceRepository(String sourceRepository) {
            this.sourceRepository = sourceRepository;
            return this;
        }

        @Override
        public final Builder sourceRepository(SourceRepository sourceRepository) {
            this.sourceRepository(sourceRepository.toString());
            return this;
        }

        public final void setSourceRepository(String sourceRepository) {
            this.sourceRepository = sourceRepository;
        }

        public final String getSourceLocation() {
            return this.sourceLocation;
        }

        @Override
        public final Builder sourceLocation(String sourceLocation) {
            this.sourceLocation = sourceLocation;
            return this;
        }

        public final void setSourceLocation(String sourceLocation) {
            this.sourceLocation = sourceLocation;
        }

        public SourceBuildInformation build() {
            return new SourceBuildInformation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SourceBuildInformation> {
        public Builder sourceType(String var1);

        public Builder sourceType(SourceType var1);

        public Builder sourceRepository(String var1);

        public Builder sourceRepository(SourceRepository var1);

        public Builder sourceLocation(String var1);
    }
}

