/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.elasticbeanstalk.model.ActionStatus;
import software.amazon.awssdk.services.elasticbeanstalk.model.ActionType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ManagedAction
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ManagedAction> {
    private static final SdkField<String> ACTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ActionId").getter(ManagedAction.getter(ManagedAction::actionId)).setter(ManagedAction.setter(Builder::actionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionId").build()}).build();
    private static final SdkField<String> ACTION_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ActionDescription").getter(ManagedAction.getter(ManagedAction::actionDescription)).setter(ManagedAction.setter(Builder::actionDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionDescription").build()}).build();
    private static final SdkField<String> ACTION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ActionType").getter(ManagedAction.getter(ManagedAction::actionTypeAsString)).setter(ManagedAction.setter(Builder::actionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionType").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(ManagedAction.getter(ManagedAction::statusAsString)).setter(ManagedAction.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Instant> WINDOW_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("WindowStartTime").getter(ManagedAction.getter(ManagedAction::windowStartTime)).setter(ManagedAction.setter(Builder::windowStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WindowStartTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_ID_FIELD, ACTION_DESCRIPTION_FIELD, ACTION_TYPE_FIELD, STATUS_FIELD, WINDOW_START_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ManagedAction.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String actionId;
    private final String actionDescription;
    private final String actionType;
    private final String status;
    private final Instant windowStartTime;

    private ManagedAction(BuilderImpl builder) {
        this.actionId = builder.actionId;
        this.actionDescription = builder.actionDescription;
        this.actionType = builder.actionType;
        this.status = builder.status;
        this.windowStartTime = builder.windowStartTime;
    }

    public final String actionId() {
        return this.actionId;
    }

    public final String actionDescription() {
        return this.actionDescription;
    }

    public final ActionType actionType() {
        return ActionType.fromValue(this.actionType);
    }

    public final String actionTypeAsString() {
        return this.actionType;
    }

    public final ActionStatus status() {
        return ActionStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant windowStartTime() {
        return this.windowStartTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.actionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.windowStartTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ManagedAction)) {
            return false;
        }
        ManagedAction other = (ManagedAction)obj;
        return Objects.equals(this.actionId(), other.actionId()) && Objects.equals(this.actionDescription(), other.actionDescription()) && Objects.equals(this.actionTypeAsString(), other.actionTypeAsString()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.windowStartTime(), other.windowStartTime());
    }

    public final String toString() {
        return ToString.builder((String)"ManagedAction").add("ActionId", (Object)this.actionId()).add("ActionDescription", (Object)this.actionDescription()).add("ActionType", (Object)this.actionTypeAsString()).add("Status", (Object)this.statusAsString()).add("WindowStartTime", (Object)this.windowStartTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ActionId": {
                return Optional.ofNullable(clazz.cast(this.actionId()));
            }
            case "ActionDescription": {
                return Optional.ofNullable(clazz.cast(this.actionDescription()));
            }
            case "ActionType": {
                return Optional.ofNullable(clazz.cast(this.actionTypeAsString()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "WindowStartTime": {
                return Optional.ofNullable(clazz.cast(this.windowStartTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ActionId", ACTION_ID_FIELD);
        map.put("ActionDescription", ACTION_DESCRIPTION_FIELD);
        map.put("ActionType", ACTION_TYPE_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("WindowStartTime", WINDOW_START_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ManagedAction, T> g) {
        return obj -> g.apply((ManagedAction)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String actionId;
        private String actionDescription;
        private String actionType;
        private String status;
        private Instant windowStartTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ManagedAction model) {
            this.actionId(model.actionId);
            this.actionDescription(model.actionDescription);
            this.actionType(model.actionType);
            this.status(model.status);
            this.windowStartTime(model.windowStartTime);
        }

        public final String getActionId() {
            return this.actionId;
        }

        public final void setActionId(String actionId) {
            this.actionId = actionId;
        }

        @Override
        public final Builder actionId(String actionId) {
            this.actionId = actionId;
            return this;
        }

        public final String getActionDescription() {
            return this.actionDescription;
        }

        public final void setActionDescription(String actionDescription) {
            this.actionDescription = actionDescription;
        }

        @Override
        public final Builder actionDescription(String actionDescription) {
            this.actionDescription = actionDescription;
            return this;
        }

        public final String getActionType() {
            return this.actionType;
        }

        public final void setActionType(String actionType) {
            this.actionType = actionType;
        }

        @Override
        public final Builder actionType(String actionType) {
            this.actionType = actionType;
            return this;
        }

        @Override
        public final Builder actionType(ActionType actionType) {
            this.actionType(actionType == null ? null : actionType.toString());
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ActionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getWindowStartTime() {
            return this.windowStartTime;
        }

        public final void setWindowStartTime(Instant windowStartTime) {
            this.windowStartTime = windowStartTime;
        }

        @Override
        public final Builder windowStartTime(Instant windowStartTime) {
            this.windowStartTime = windowStartTime;
            return this;
        }

        public ManagedAction build() {
            return new ManagedAction(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ManagedAction> {
        public Builder actionId(String var1);

        public Builder actionDescription(String var1);

        public Builder actionType(String var1);

        public Builder actionType(ActionType var1);

        public Builder status(String var1);

        public Builder status(ActionStatus var1);

        public Builder windowStartTime(Instant var1);
    }
}

