/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.elasticbeanstalk.model.ElasticBeanstalkResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.PlatformBuilder;
import software.amazon.awssdk.services.elasticbeanstalk.model.PlatformSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreatePlatformVersionResponse
extends ElasticBeanstalkResponse
implements ToCopyableBuilder<Builder, CreatePlatformVersionResponse> {
    private static final SdkField<PlatformSummary> PLATFORM_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PlatformSummary").getter(CreatePlatformVersionResponse.getter(CreatePlatformVersionResponse::platformSummary)).setter(CreatePlatformVersionResponse.setter(Builder::platformSummary)).constructor(PlatformSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlatformSummary").build()}).build();
    private static final SdkField<PlatformBuilder> PLATFORM_BUILDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PlatformBuilder").getter(CreatePlatformVersionResponse.getter(CreatePlatformVersionResponse::platformBuilder)).setter(CreatePlatformVersionResponse.setter(Builder::platformBuilder)).constructor(PlatformBuilder::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Builder").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PLATFORM_SUMMARY_FIELD, PLATFORM_BUILDER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("PlatformSummary", PLATFORM_SUMMARY_FIELD);
            this.put("Builder", PLATFORM_BUILDER_FIELD);
        }
    });
    private final PlatformSummary platformSummary;
    private final PlatformBuilder platformBuilder;

    private CreatePlatformVersionResponse(BuilderImpl builder) {
        super(builder);
        this.platformSummary = builder.platformSummary;
        this.platformBuilder = builder.platformBuilder;
    }

    public final PlatformSummary platformSummary() {
        return this.platformSummary;
    }

    public final PlatformBuilder platformBuilder() {
        return this.platformBuilder;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.platformSummary());
        hashCode = 31 * hashCode + Objects.hashCode(this.platformBuilder());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePlatformVersionResponse)) {
            return false;
        }
        CreatePlatformVersionResponse other = (CreatePlatformVersionResponse)((Object)obj);
        return Objects.equals(this.platformSummary(), other.platformSummary()) && Objects.equals(this.platformBuilder(), other.platformBuilder());
    }

    public final String toString() {
        return ToString.builder((String)"CreatePlatformVersionResponse").add("PlatformSummary", (Object)this.platformSummary()).add("PlatformBuilder", (Object)this.platformBuilder()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PlatformSummary": {
                return Optional.ofNullable(clazz.cast(this.platformSummary()));
            }
            case "PlatformBuilder": {
                return Optional.ofNullable(clazz.cast(this.platformBuilder()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreatePlatformVersionResponse, T> g) {
        return obj -> g.apply((CreatePlatformVersionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElasticBeanstalkResponse.BuilderImpl
    implements Builder {
        private PlatformSummary platformSummary;
        private PlatformBuilder platformBuilder;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePlatformVersionResponse model) {
            super(model);
            this.platformSummary(model.platformSummary);
            this.platformBuilder(model.platformBuilder);
        }

        public final PlatformSummary.Builder getPlatformSummary() {
            return this.platformSummary != null ? this.platformSummary.toBuilder() : null;
        }

        public final void setPlatformSummary(PlatformSummary.BuilderImpl platformSummary) {
            this.platformSummary = platformSummary != null ? platformSummary.build() : null;
        }

        @Override
        public final Builder platformSummary(PlatformSummary platformSummary) {
            this.platformSummary = platformSummary;
            return this;
        }

        public final PlatformBuilder.Builder getPlatformBuilder() {
            return this.platformBuilder != null ? this.platformBuilder.toBuilder() : null;
        }

        public final void setPlatformBuilder(PlatformBuilder.BuilderImpl platformBuilder) {
            this.platformBuilder = platformBuilder != null ? platformBuilder.build() : null;
        }

        @Override
        public final Builder platformBuilder(PlatformBuilder platformBuilder) {
            this.platformBuilder = platformBuilder;
            return this;
        }

        @Override
        public CreatePlatformVersionResponse build() {
            return new CreatePlatformVersionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ElasticBeanstalkResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreatePlatformVersionResponse> {
        public Builder platformSummary(PlatformSummary var1);

        default public Builder platformSummary(Consumer<PlatformSummary.Builder> platformSummary) {
            return this.platformSummary((PlatformSummary)((PlatformSummary.Builder)PlatformSummary.builder().applyMutation(platformSummary)).build());
        }

        public Builder platformBuilder(PlatformBuilder var1);

        default public Builder platformBuilder(Consumer<PlatformBuilder.Builder> platformBuilder) {
            return this.platformBuilder((PlatformBuilder)((PlatformBuilder.Builder)PlatformBuilder.builder().applyMutation(platformBuilder)).build());
        }
    }
}

