/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Health details for an AWS Elastic Beanstalk environment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeEnvironmentHealthResponse extends ElasticBeanstalkResponse implements
        ToCopyableBuilder<DescribeEnvironmentHealthResponse.Builder, DescribeEnvironmentHealthResponse> {
    private static final SdkField<String> ENVIRONMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EnvironmentName").getter(getter(DescribeEnvironmentHealthResponse::environmentName))
            .setter(setter(Builder::environmentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnvironmentName").build()).build();

    private static final SdkField<String> HEALTH_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HealthStatus").getter(getter(DescribeEnvironmentHealthResponse::healthStatus))
            .setter(setter(Builder::healthStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthStatus").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(DescribeEnvironmentHealthResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> COLOR_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Color")
            .getter(getter(DescribeEnvironmentHealthResponse::color)).setter(setter(Builder::color))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Color").build()).build();

    private static final SdkField<List<String>> CAUSES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Causes")
            .getter(getter(DescribeEnvironmentHealthResponse::causes))
            .setter(setter(Builder::causes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Causes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ApplicationMetrics> APPLICATION_METRICS_FIELD = SdkField
            .<ApplicationMetrics> builder(MarshallingType.SDK_POJO).memberName("ApplicationMetrics")
            .getter(getter(DescribeEnvironmentHealthResponse::applicationMetrics)).setter(setter(Builder::applicationMetrics))
            .constructor(ApplicationMetrics::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationMetrics").build())
            .build();

    private static final SdkField<InstanceHealthSummary> INSTANCES_HEALTH_FIELD = SdkField
            .<InstanceHealthSummary> builder(MarshallingType.SDK_POJO).memberName("InstancesHealth")
            .getter(getter(DescribeEnvironmentHealthResponse::instancesHealth)).setter(setter(Builder::instancesHealth))
            .constructor(InstanceHealthSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstancesHealth").build()).build();

    private static final SdkField<Instant> REFRESHED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("RefreshedAt").getter(getter(DescribeEnvironmentHealthResponse::refreshedAt))
            .setter(setter(Builder::refreshedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RefreshedAt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENVIRONMENT_NAME_FIELD,
            HEALTH_STATUS_FIELD, STATUS_FIELD, COLOR_FIELD, CAUSES_FIELD, APPLICATION_METRICS_FIELD, INSTANCES_HEALTH_FIELD,
            REFRESHED_AT_FIELD));

    private final String environmentName;

    private final String healthStatus;

    private final String status;

    private final String color;

    private final List<String> causes;

    private final ApplicationMetrics applicationMetrics;

    private final InstanceHealthSummary instancesHealth;

    private final Instant refreshedAt;

    private DescribeEnvironmentHealthResponse(BuilderImpl builder) {
        super(builder);
        this.environmentName = builder.environmentName;
        this.healthStatus = builder.healthStatus;
        this.status = builder.status;
        this.color = builder.color;
        this.causes = builder.causes;
        this.applicationMetrics = builder.applicationMetrics;
        this.instancesHealth = builder.instancesHealth;
        this.refreshedAt = builder.refreshedAt;
    }

    /**
     * <p>
     * The environment's name.
     * </p>
     * 
     * @return The environment's name.
     */
    public final String environmentName() {
        return environmentName;
    }

    /**
     * <p>
     * The <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/health-enhanced-status.html">health
     * status</a> of the environment. For example, <code>Ok</code>.
     * </p>
     * 
     * @return The <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/health-enhanced-status.html">health
     *         status</a> of the environment. For example, <code>Ok</code>.
     */
    public final String healthStatus() {
        return healthStatus;
    }

    /**
     * <p>
     * The environment's operational status. <code>Ready</code>, <code>Launching</code>, <code>Updating</code>,
     * <code>Terminating</code>, or <code>Terminated</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link EnvironmentHealth#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The environment's operational status. <code>Ready</code>, <code>Launching</code>, <code>Updating</code>,
     *         <code>Terminating</code>, or <code>Terminated</code>.
     * @see EnvironmentHealth
     */
    public final EnvironmentHealth status() {
        return EnvironmentHealth.fromValue(status);
    }

    /**
     * <p>
     * The environment's operational status. <code>Ready</code>, <code>Launching</code>, <code>Updating</code>,
     * <code>Terminating</code>, or <code>Terminated</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link EnvironmentHealth#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The environment's operational status. <code>Ready</code>, <code>Launching</code>, <code>Updating</code>,
     *         <code>Terminating</code>, or <code>Terminated</code>.
     * @see EnvironmentHealth
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/health-enhanced-status.html">health color</a>
     * of the environment.
     * </p>
     * 
     * @return The <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/health-enhanced-status.html">health
     *         color</a> of the environment.
     */
    public final String color() {
        return color;
    }

    /**
     * For responses, this returns true if the service returned a value for the Causes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasCauses() {
        return causes != null && !(causes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Descriptions of the data that contributed to the environment's current health status.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCauses} method.
     * </p>
     * 
     * @return Descriptions of the data that contributed to the environment's current health status.
     */
    public final List<String> causes() {
        return causes;
    }

    /**
     * <p>
     * Application request metrics for the environment.
     * </p>
     * 
     * @return Application request metrics for the environment.
     */
    public final ApplicationMetrics applicationMetrics() {
        return applicationMetrics;
    }

    /**
     * <p>
     * Summary health information for the instances in the environment.
     * </p>
     * 
     * @return Summary health information for the instances in the environment.
     */
    public final InstanceHealthSummary instancesHealth() {
        return instancesHealth;
    }

    /**
     * <p>
     * The date and time that the health information was retrieved.
     * </p>
     * 
     * @return The date and time that the health information was retrieved.
     */
    public final Instant refreshedAt() {
        return refreshedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(environmentName());
        hashCode = 31 * hashCode + Objects.hashCode(healthStatus());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(color());
        hashCode = 31 * hashCode + Objects.hashCode(hasCauses() ? causes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(applicationMetrics());
        hashCode = 31 * hashCode + Objects.hashCode(instancesHealth());
        hashCode = 31 * hashCode + Objects.hashCode(refreshedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEnvironmentHealthResponse)) {
            return false;
        }
        DescribeEnvironmentHealthResponse other = (DescribeEnvironmentHealthResponse) obj;
        return Objects.equals(environmentName(), other.environmentName()) && Objects.equals(healthStatus(), other.healthStatus())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(color(), other.color())
                && hasCauses() == other.hasCauses() && Objects.equals(causes(), other.causes())
                && Objects.equals(applicationMetrics(), other.applicationMetrics())
                && Objects.equals(instancesHealth(), other.instancesHealth())
                && Objects.equals(refreshedAt(), other.refreshedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeEnvironmentHealthResponse").add("EnvironmentName", environmentName())
                .add("HealthStatus", healthStatus()).add("Status", statusAsString()).add("Color", color())
                .add("Causes", hasCauses() ? causes() : null).add("ApplicationMetrics", applicationMetrics())
                .add("InstancesHealth", instancesHealth()).add("RefreshedAt", refreshedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EnvironmentName":
            return Optional.ofNullable(clazz.cast(environmentName()));
        case "HealthStatus":
            return Optional.ofNullable(clazz.cast(healthStatus()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "Color":
            return Optional.ofNullable(clazz.cast(color()));
        case "Causes":
            return Optional.ofNullable(clazz.cast(causes()));
        case "ApplicationMetrics":
            return Optional.ofNullable(clazz.cast(applicationMetrics()));
        case "InstancesHealth":
            return Optional.ofNullable(clazz.cast(instancesHealth()));
        case "RefreshedAt":
            return Optional.ofNullable(clazz.cast(refreshedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeEnvironmentHealthResponse, T> g) {
        return obj -> g.apply((DescribeEnvironmentHealthResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticBeanstalkResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeEnvironmentHealthResponse> {
        /**
         * <p>
         * The environment's name.
         * </p>
         * 
         * @param environmentName
         *        The environment's name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentName(String environmentName);

        /**
         * <p>
         * The <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/health-enhanced-status.html">health
         * status</a> of the environment. For example, <code>Ok</code>.
         * </p>
         * 
         * @param healthStatus
         *        The <a
         *        href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/health-enhanced-status.html">health
         *        status</a> of the environment. For example, <code>Ok</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthStatus(String healthStatus);

        /**
         * <p>
         * The environment's operational status. <code>Ready</code>, <code>Launching</code>, <code>Updating</code>,
         * <code>Terminating</code>, or <code>Terminated</code>.
         * </p>
         * 
         * @param status
         *        The environment's operational status. <code>Ready</code>, <code>Launching</code>,
         *        <code>Updating</code>, <code>Terminating</code>, or <code>Terminated</code>.
         * @see EnvironmentHealth
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnvironmentHealth
         */
        Builder status(String status);

        /**
         * <p>
         * The environment's operational status. <code>Ready</code>, <code>Launching</code>, <code>Updating</code>,
         * <code>Terminating</code>, or <code>Terminated</code>.
         * </p>
         * 
         * @param status
         *        The environment's operational status. <code>Ready</code>, <code>Launching</code>,
         *        <code>Updating</code>, <code>Terminating</code>, or <code>Terminated</code>.
         * @see EnvironmentHealth
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnvironmentHealth
         */
        Builder status(EnvironmentHealth status);

        /**
         * <p>
         * The <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/health-enhanced-status.html">health
         * color</a> of the environment.
         * </p>
         * 
         * @param color
         *        The <a
         *        href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/health-enhanced-status.html">health
         *        color</a> of the environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder color(String color);

        /**
         * <p>
         * Descriptions of the data that contributed to the environment's current health status.
         * </p>
         * 
         * @param causes
         *        Descriptions of the data that contributed to the environment's current health status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder causes(Collection<String> causes);

        /**
         * <p>
         * Descriptions of the data that contributed to the environment's current health status.
         * </p>
         * 
         * @param causes
         *        Descriptions of the data that contributed to the environment's current health status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder causes(String... causes);

        /**
         * <p>
         * Application request metrics for the environment.
         * </p>
         * 
         * @param applicationMetrics
         *        Application request metrics for the environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationMetrics(ApplicationMetrics applicationMetrics);

        /**
         * <p>
         * Application request metrics for the environment.
         * </p>
         * This is a convenience method that creates an instance of the {@link ApplicationMetrics.Builder} avoiding the
         * need to create one manually via {@link ApplicationMetrics#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ApplicationMetrics.Builder#build()} is called immediately and its
         * result is passed to {@link #applicationMetrics(ApplicationMetrics)}.
         * 
         * @param applicationMetrics
         *        a consumer that will call methods on {@link ApplicationMetrics.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #applicationMetrics(ApplicationMetrics)
         */
        default Builder applicationMetrics(Consumer<ApplicationMetrics.Builder> applicationMetrics) {
            return applicationMetrics(ApplicationMetrics.builder().applyMutation(applicationMetrics).build());
        }

        /**
         * <p>
         * Summary health information for the instances in the environment.
         * </p>
         * 
         * @param instancesHealth
         *        Summary health information for the instances in the environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instancesHealth(InstanceHealthSummary instancesHealth);

        /**
         * <p>
         * Summary health information for the instances in the environment.
         * </p>
         * This is a convenience method that creates an instance of the {@link InstanceHealthSummary.Builder} avoiding
         * the need to create one manually via {@link InstanceHealthSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InstanceHealthSummary.Builder#build()} is called immediately and
         * its result is passed to {@link #instancesHealth(InstanceHealthSummary)}.
         * 
         * @param instancesHealth
         *        a consumer that will call methods on {@link InstanceHealthSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instancesHealth(InstanceHealthSummary)
         */
        default Builder instancesHealth(Consumer<InstanceHealthSummary.Builder> instancesHealth) {
            return instancesHealth(InstanceHealthSummary.builder().applyMutation(instancesHealth).build());
        }

        /**
         * <p>
         * The date and time that the health information was retrieved.
         * </p>
         * 
         * @param refreshedAt
         *        The date and time that the health information was retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder refreshedAt(Instant refreshedAt);
    }

    static final class BuilderImpl extends ElasticBeanstalkResponse.BuilderImpl implements Builder {
        private String environmentName;

        private String healthStatus;

        private String status;

        private String color;

        private List<String> causes = DefaultSdkAutoConstructList.getInstance();

        private ApplicationMetrics applicationMetrics;

        private InstanceHealthSummary instancesHealth;

        private Instant refreshedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEnvironmentHealthResponse model) {
            super(model);
            environmentName(model.environmentName);
            healthStatus(model.healthStatus);
            status(model.status);
            color(model.color);
            causes(model.causes);
            applicationMetrics(model.applicationMetrics);
            instancesHealth(model.instancesHealth);
            refreshedAt(model.refreshedAt);
        }

        public final String getEnvironmentName() {
            return environmentName;
        }

        public final void setEnvironmentName(String environmentName) {
            this.environmentName = environmentName;
        }

        @Override
        public final Builder environmentName(String environmentName) {
            this.environmentName = environmentName;
            return this;
        }

        public final String getHealthStatus() {
            return healthStatus;
        }

        public final void setHealthStatus(String healthStatus) {
            this.healthStatus = healthStatus;
        }

        @Override
        public final Builder healthStatus(String healthStatus) {
            this.healthStatus = healthStatus;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(EnvironmentHealth status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getColor() {
            return color;
        }

        public final void setColor(String color) {
            this.color = color;
        }

        @Override
        public final Builder color(String color) {
            this.color = color;
            return this;
        }

        public final Collection<String> getCauses() {
            if (causes instanceof SdkAutoConstructList) {
                return null;
            }
            return causes;
        }

        public final void setCauses(Collection<String> causes) {
            this.causes = CausesCopier.copy(causes);
        }

        @Override
        public final Builder causes(Collection<String> causes) {
            this.causes = CausesCopier.copy(causes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder causes(String... causes) {
            causes(Arrays.asList(causes));
            return this;
        }

        public final ApplicationMetrics.Builder getApplicationMetrics() {
            return applicationMetrics != null ? applicationMetrics.toBuilder() : null;
        }

        public final void setApplicationMetrics(ApplicationMetrics.BuilderImpl applicationMetrics) {
            this.applicationMetrics = applicationMetrics != null ? applicationMetrics.build() : null;
        }

        @Override
        public final Builder applicationMetrics(ApplicationMetrics applicationMetrics) {
            this.applicationMetrics = applicationMetrics;
            return this;
        }

        public final InstanceHealthSummary.Builder getInstancesHealth() {
            return instancesHealth != null ? instancesHealth.toBuilder() : null;
        }

        public final void setInstancesHealth(InstanceHealthSummary.BuilderImpl instancesHealth) {
            this.instancesHealth = instancesHealth != null ? instancesHealth.build() : null;
        }

        @Override
        public final Builder instancesHealth(InstanceHealthSummary instancesHealth) {
            this.instancesHealth = instancesHealth;
            return this;
        }

        public final Instant getRefreshedAt() {
            return refreshedAt;
        }

        public final void setRefreshedAt(Instant refreshedAt) {
            this.refreshedAt = refreshedAt;
        }

        @Override
        public final Builder refreshedAt(Instant refreshedAt) {
            this.refreshedAt = refreshedAt;
            return this;
        }

        @Override
        public DescribeEnvironmentHealthResponse build() {
            return new DescribeEnvironmentHealthResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
