/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.elasticbeanstalk.model.ElasticBeanstalkRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeConfigurationSettingsRequest
extends ElasticBeanstalkRequest
implements ToCopyableBuilder<Builder, DescribeConfigurationSettingsRequest> {
    private static final SdkField<String> APPLICATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationName").getter(DescribeConfigurationSettingsRequest.getter(DescribeConfigurationSettingsRequest::applicationName)).setter(DescribeConfigurationSettingsRequest.setter(Builder::applicationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationName").build()}).build();
    private static final SdkField<String> TEMPLATE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TemplateName").getter(DescribeConfigurationSettingsRequest.getter(DescribeConfigurationSettingsRequest::templateName)).setter(DescribeConfigurationSettingsRequest.setter(Builder::templateName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateName").build()}).build();
    private static final SdkField<String> ENVIRONMENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EnvironmentName").getter(DescribeConfigurationSettingsRequest.getter(DescribeConfigurationSettingsRequest::environmentName)).setter(DescribeConfigurationSettingsRequest.setter(Builder::environmentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnvironmentName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_NAME_FIELD, TEMPLATE_NAME_FIELD, ENVIRONMENT_NAME_FIELD));
    private final String applicationName;
    private final String templateName;
    private final String environmentName;

    private DescribeConfigurationSettingsRequest(BuilderImpl builder) {
        super(builder);
        this.applicationName = builder.applicationName;
        this.templateName = builder.templateName;
        this.environmentName = builder.environmentName;
    }

    public final String applicationName() {
        return this.applicationName;
    }

    public final String templateName() {
        return this.templateName;
    }

    public final String environmentName() {
        return this.environmentName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateName());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeConfigurationSettingsRequest)) {
            return false;
        }
        DescribeConfigurationSettingsRequest other = (DescribeConfigurationSettingsRequest)((Object)obj);
        return Objects.equals(this.applicationName(), other.applicationName()) && Objects.equals(this.templateName(), other.templateName()) && Objects.equals(this.environmentName(), other.environmentName());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeConfigurationSettingsRequest").add("ApplicationName", (Object)this.applicationName()).add("TemplateName", (Object)this.templateName()).add("EnvironmentName", (Object)this.environmentName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationName": {
                return Optional.ofNullable(clazz.cast(this.applicationName()));
            }
            case "TemplateName": {
                return Optional.ofNullable(clazz.cast(this.templateName()));
            }
            case "EnvironmentName": {
                return Optional.ofNullable(clazz.cast(this.environmentName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeConfigurationSettingsRequest, T> g) {
        return obj -> g.apply((DescribeConfigurationSettingsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElasticBeanstalkRequest.BuilderImpl
    implements Builder {
        private String applicationName;
        private String templateName;
        private String environmentName;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeConfigurationSettingsRequest model) {
            super(model);
            this.applicationName(model.applicationName);
            this.templateName(model.templateName);
            this.environmentName(model.environmentName);
        }

        public final String getApplicationName() {
            return this.applicationName;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final String getTemplateName() {
            return this.templateName;
        }

        public final void setTemplateName(String templateName) {
            this.templateName = templateName;
        }

        @Override
        public final Builder templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        public final String getEnvironmentName() {
            return this.environmentName;
        }

        public final void setEnvironmentName(String environmentName) {
            this.environmentName = environmentName;
        }

        @Override
        public final Builder environmentName(String environmentName) {
            this.environmentName = environmentName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeConfigurationSettingsRequest build() {
            return new DescribeConfigurationSettingsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ElasticBeanstalkRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeConfigurationSettingsRequest> {
        public Builder applicationName(String var1);

        public Builder templateName(String var1);

        public Builder environmentName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

