/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticbeanstalk.model.ApplicationResourceLifecycleConfig;
import software.amazon.awssdk.services.elasticbeanstalk.model.ConfigurationTemplateNamesListCopier;
import software.amazon.awssdk.services.elasticbeanstalk.model.VersionLabelsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ApplicationDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ApplicationDescription> {
    private static final SdkField<String> APPLICATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationArn").getter(ApplicationDescription.getter(ApplicationDescription::applicationArn)).setter(ApplicationDescription.setter(Builder::applicationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationArn").build()}).build();
    private static final SdkField<String> APPLICATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationName").getter(ApplicationDescription.getter(ApplicationDescription::applicationName)).setter(ApplicationDescription.setter(Builder::applicationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(ApplicationDescription.getter(ApplicationDescription::description)).setter(ApplicationDescription.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Instant> DATE_CREATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("DateCreated").getter(ApplicationDescription.getter(ApplicationDescription::dateCreated)).setter(ApplicationDescription.setter(Builder::dateCreated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DateCreated").build()}).build();
    private static final SdkField<Instant> DATE_UPDATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("DateUpdated").getter(ApplicationDescription.getter(ApplicationDescription::dateUpdated)).setter(ApplicationDescription.setter(Builder::dateUpdated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DateUpdated").build()}).build();
    private static final SdkField<List<String>> VERSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Versions").getter(ApplicationDescription.getter(ApplicationDescription::versions)).setter(ApplicationDescription.setter(Builder::versions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Versions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> CONFIGURATION_TEMPLATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ConfigurationTemplates").getter(ApplicationDescription.getter(ApplicationDescription::configurationTemplates)).setter(ApplicationDescription.setter(Builder::configurationTemplates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationTemplates").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ApplicationResourceLifecycleConfig> RESOURCE_LIFECYCLE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ResourceLifecycleConfig").getter(ApplicationDescription.getter(ApplicationDescription::resourceLifecycleConfig)).setter(ApplicationDescription.setter(Builder::resourceLifecycleConfig)).constructor(ApplicationResourceLifecycleConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceLifecycleConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ARN_FIELD, APPLICATION_NAME_FIELD, DESCRIPTION_FIELD, DATE_CREATED_FIELD, DATE_UPDATED_FIELD, VERSIONS_FIELD, CONFIGURATION_TEMPLATES_FIELD, RESOURCE_LIFECYCLE_CONFIG_FIELD));
    private static final long serialVersionUID = 1L;
    private final String applicationArn;
    private final String applicationName;
    private final String description;
    private final Instant dateCreated;
    private final Instant dateUpdated;
    private final List<String> versions;
    private final List<String> configurationTemplates;
    private final ApplicationResourceLifecycleConfig resourceLifecycleConfig;

    private ApplicationDescription(BuilderImpl builder) {
        this.applicationArn = builder.applicationArn;
        this.applicationName = builder.applicationName;
        this.description = builder.description;
        this.dateCreated = builder.dateCreated;
        this.dateUpdated = builder.dateUpdated;
        this.versions = builder.versions;
        this.configurationTemplates = builder.configurationTemplates;
        this.resourceLifecycleConfig = builder.resourceLifecycleConfig;
    }

    public final String applicationArn() {
        return this.applicationArn;
    }

    public final String applicationName() {
        return this.applicationName;
    }

    public final String description() {
        return this.description;
    }

    public final Instant dateCreated() {
        return this.dateCreated;
    }

    public final Instant dateUpdated() {
        return this.dateUpdated;
    }

    public final boolean hasVersions() {
        return this.versions != null && !(this.versions instanceof SdkAutoConstructList);
    }

    public final List<String> versions() {
        return this.versions;
    }

    public final boolean hasConfigurationTemplates() {
        return this.configurationTemplates != null && !(this.configurationTemplates instanceof SdkAutoConstructList);
    }

    public final List<String> configurationTemplates() {
        return this.configurationTemplates;
    }

    public final ApplicationResourceLifecycleConfig resourceLifecycleConfig() {
        return this.resourceLifecycleConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.dateCreated());
        hashCode = 31 * hashCode + Objects.hashCode(this.dateUpdated());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVersions() ? this.versions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConfigurationTemplates() ? this.configurationTemplates() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceLifecycleConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationDescription)) {
            return false;
        }
        ApplicationDescription other = (ApplicationDescription)obj;
        return Objects.equals(this.applicationArn(), other.applicationArn()) && Objects.equals(this.applicationName(), other.applicationName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.dateCreated(), other.dateCreated()) && Objects.equals(this.dateUpdated(), other.dateUpdated()) && this.hasVersions() == other.hasVersions() && Objects.equals(this.versions(), other.versions()) && this.hasConfigurationTemplates() == other.hasConfigurationTemplates() && Objects.equals(this.configurationTemplates(), other.configurationTemplates()) && Objects.equals(this.resourceLifecycleConfig(), other.resourceLifecycleConfig());
    }

    public final String toString() {
        return ToString.builder((String)"ApplicationDescription").add("ApplicationArn", (Object)this.applicationArn()).add("ApplicationName", (Object)this.applicationName()).add("Description", (Object)this.description()).add("DateCreated", (Object)this.dateCreated()).add("DateUpdated", (Object)this.dateUpdated()).add("Versions", this.hasVersions() ? this.versions() : null).add("ConfigurationTemplates", this.hasConfigurationTemplates() ? this.configurationTemplates() : null).add("ResourceLifecycleConfig", (Object)this.resourceLifecycleConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationArn": {
                return Optional.ofNullable(clazz.cast(this.applicationArn()));
            }
            case "ApplicationName": {
                return Optional.ofNullable(clazz.cast(this.applicationName()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "DateCreated": {
                return Optional.ofNullable(clazz.cast(this.dateCreated()));
            }
            case "DateUpdated": {
                return Optional.ofNullable(clazz.cast(this.dateUpdated()));
            }
            case "Versions": {
                return Optional.ofNullable(clazz.cast(this.versions()));
            }
            case "ConfigurationTemplates": {
                return Optional.ofNullable(clazz.cast(this.configurationTemplates()));
            }
            case "ResourceLifecycleConfig": {
                return Optional.ofNullable(clazz.cast(this.resourceLifecycleConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ApplicationDescription, T> g) {
        return obj -> g.apply((ApplicationDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String applicationArn;
        private String applicationName;
        private String description;
        private Instant dateCreated;
        private Instant dateUpdated;
        private List<String> versions = DefaultSdkAutoConstructList.getInstance();
        private List<String> configurationTemplates = DefaultSdkAutoConstructList.getInstance();
        private ApplicationResourceLifecycleConfig resourceLifecycleConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationDescription model) {
            this.applicationArn(model.applicationArn);
            this.applicationName(model.applicationName);
            this.description(model.description);
            this.dateCreated(model.dateCreated);
            this.dateUpdated(model.dateUpdated);
            this.versions(model.versions);
            this.configurationTemplates(model.configurationTemplates);
            this.resourceLifecycleConfig(model.resourceLifecycleConfig);
        }

        public final String getApplicationArn() {
            return this.applicationArn;
        }

        public final void setApplicationArn(String applicationArn) {
            this.applicationArn = applicationArn;
        }

        @Override
        @Transient
        public final Builder applicationArn(String applicationArn) {
            this.applicationArn = applicationArn;
            return this;
        }

        public final String getApplicationName() {
            return this.applicationName;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        @Override
        @Transient
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getDateCreated() {
            return this.dateCreated;
        }

        public final void setDateCreated(Instant dateCreated) {
            this.dateCreated = dateCreated;
        }

        @Override
        @Transient
        public final Builder dateCreated(Instant dateCreated) {
            this.dateCreated = dateCreated;
            return this;
        }

        public final Instant getDateUpdated() {
            return this.dateUpdated;
        }

        public final void setDateUpdated(Instant dateUpdated) {
            this.dateUpdated = dateUpdated;
        }

        @Override
        @Transient
        public final Builder dateUpdated(Instant dateUpdated) {
            this.dateUpdated = dateUpdated;
            return this;
        }

        public final Collection<String> getVersions() {
            if (this.versions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.versions;
        }

        public final void setVersions(Collection<String> versions) {
            this.versions = VersionLabelsListCopier.copy(versions);
        }

        @Override
        @Transient
        public final Builder versions(Collection<String> versions) {
            this.versions = VersionLabelsListCopier.copy(versions);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder versions(String ... versions) {
            this.versions(Arrays.asList(versions));
            return this;
        }

        public final Collection<String> getConfigurationTemplates() {
            if (this.configurationTemplates instanceof SdkAutoConstructList) {
                return null;
            }
            return this.configurationTemplates;
        }

        public final void setConfigurationTemplates(Collection<String> configurationTemplates) {
            this.configurationTemplates = ConfigurationTemplateNamesListCopier.copy(configurationTemplates);
        }

        @Override
        @Transient
        public final Builder configurationTemplates(Collection<String> configurationTemplates) {
            this.configurationTemplates = ConfigurationTemplateNamesListCopier.copy(configurationTemplates);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder configurationTemplates(String ... configurationTemplates) {
            this.configurationTemplates(Arrays.asList(configurationTemplates));
            return this;
        }

        public final ApplicationResourceLifecycleConfig.Builder getResourceLifecycleConfig() {
            return this.resourceLifecycleConfig != null ? this.resourceLifecycleConfig.toBuilder() : null;
        }

        public final void setResourceLifecycleConfig(ApplicationResourceLifecycleConfig.BuilderImpl resourceLifecycleConfig) {
            this.resourceLifecycleConfig = resourceLifecycleConfig != null ? resourceLifecycleConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder resourceLifecycleConfig(ApplicationResourceLifecycleConfig resourceLifecycleConfig) {
            this.resourceLifecycleConfig = resourceLifecycleConfig;
            return this;
        }

        public ApplicationDescription build() {
            return new ApplicationDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ApplicationDescription> {
        public Builder applicationArn(String var1);

        public Builder applicationName(String var1);

        public Builder description(String var1);

        public Builder dateCreated(Instant var1);

        public Builder dateUpdated(Instant var1);

        public Builder versions(Collection<String> var1);

        public Builder versions(String ... var1);

        public Builder configurationTemplates(Collection<String> var1);

        public Builder configurationTemplates(String ... var1);

        public Builder resourceLifecycleConfig(ApplicationResourceLifecycleConfig var1);

        default public Builder resourceLifecycleConfig(Consumer<ApplicationResourceLifecycleConfig.Builder> resourceLifecycleConfig) {
            return this.resourceLifecycleConfig((ApplicationResourceLifecycleConfig)((ApplicationResourceLifecycleConfig.Builder)ApplicationResourceLifecycleConfig.builder().applyMutation(resourceLifecycleConfig)).build());
        }
    }
}

