/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.elasticbeanstalk.ElasticBeanstalkClient;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentManagedActionHistoryRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentManagedActionHistoryResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.ManagedActionHistoryItem;

public class DescribeEnvironmentManagedActionHistoryIterable
implements SdkIterable<DescribeEnvironmentManagedActionHistoryResponse> {
    private final ElasticBeanstalkClient client;
    private final DescribeEnvironmentManagedActionHistoryRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeEnvironmentManagedActionHistoryIterable(ElasticBeanstalkClient client, DescribeEnvironmentManagedActionHistoryRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeEnvironmentManagedActionHistoryResponseFetcher();
    }

    public Iterator<DescribeEnvironmentManagedActionHistoryResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ManagedActionHistoryItem> managedActionHistoryItems() {
        Function<DescribeEnvironmentManagedActionHistoryResponse, Iterator> getIterator = response -> {
            if (response != null && response.managedActionHistoryItems() != null) {
                return response.managedActionHistoryItems().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeEnvironmentManagedActionHistoryResponseFetcher
    implements SyncPageFetcher<DescribeEnvironmentManagedActionHistoryResponse> {
        private DescribeEnvironmentManagedActionHistoryResponseFetcher() {
        }

        public boolean hasNextPage(DescribeEnvironmentManagedActionHistoryResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeEnvironmentManagedActionHistoryResponse nextPage(DescribeEnvironmentManagedActionHistoryResponse previousPage) {
            if (previousPage == null) {
                return DescribeEnvironmentManagedActionHistoryIterable.this.client.describeEnvironmentManagedActionHistory(DescribeEnvironmentManagedActionHistoryIterable.this.firstRequest);
            }
            return DescribeEnvironmentManagedActionHistoryIterable.this.client.describeEnvironmentManagedActionHistory((DescribeEnvironmentManagedActionHistoryRequest)((Object)DescribeEnvironmentManagedActionHistoryIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

